/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualFilePointerTracker {
    private static final Set<VirtualFilePointer> storedPointers = new ReferenceOpenHashSet();
    private static Throwable trace;
    private static boolean isTracking;

    public VirtualFilePointerTracker() {
        this.storePointers();
    }

    private synchronized void storePointers() {
        if (isTracking) {
            isTracking = false;
            throw new IllegalStateException("Previous test did not call assertPointersAreDisposed() - see 'Caused by:' for its stacktrace", trace);
        }
        trace = new Throwable();
        storedPointers.clear();
        storedPointers.addAll(VirtualFilePointerTracker.dumpAllPointers());
        isTracking = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assertPointersAreDisposed() {
        if (!isTracking) {
            throw new IllegalStateException("Double call of assertPointersAreDisposed() - see 'Caused by:' for the previous call", trace);
        }
        ArrayList<VirtualFilePointer> pointers2 = new ArrayList<VirtualFilePointer>(VirtualFilePointerTracker.dumpAllPointers());
        for (int i2 = pointers2.size() - 1; i2 >= 0; --i2) {
            VirtualFilePointer pointer = (VirtualFilePointer)pointers2.get(i2);
            if (!storedPointers.remove(pointer)) continue;
            pointers2.remove(i2);
        }
        try {
            ObjectOpenCustomHashSet leaked = new ObjectOpenCustomHashSet(pointers2, (Hash.Strategy)new Hash.Strategy<VirtualFilePointer>(){

                public int hashCode(@Nullable VirtualFilePointer pointer) {
                    return pointer == null ? 0 : FileUtil.PATH_HASHING_STRATEGY.computeHashCode((Object)pointer.getUrl());
                }

                public boolean equals(VirtualFilePointer o1, VirtualFilePointer o2) {
                    return o1 == o2 || o1 != null && o2 != null && FileUtil.PATH_HASHING_STRATEGY.equals((Object)o1.getUrl(), (Object)o2.getUrl());
                }
            });
            leaked.removeAll(storedPointers);
            for (VirtualFilePointer pointer : leaked) {
                ((VirtualFilePointerImpl)pointer).throwDisposalError("Virtual pointer '" + pointer + "' hasn't been disposed: " + ((VirtualFilePointerImpl)pointer).getStackTrace());
            }
        }
        finally {
            storedPointers.clear();
            trace = new Throwable();
            isTracking = false;
        }
    }

    @NotNull
    private static Collection<VirtualFilePointer> dumpAllPointers() {
        return ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).dumpAllPointers();
    }
}

