/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.lang.Language;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileTypeManager
extends FileTypeManagerEx {
    private final FileType fileType;

    public MockFileTypeManager(FileType fileType) {
        this.fileType = fileType;
    }

    public void registerFileType(@NotNull FileType fileType) {
    }

    public void unregisterFileType(@NotNull FileType fileType) {
    }

    @NotNull
    public String getIgnoredFilesList() {
        throw new IncorrectOperationException();
    }

    public void setIgnoredFilesList(@NotNull String list) {
    }

    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list) {
        return false;
    }

    public void save() {
    }

    @NotNull
    public String getExtension(@NotNull String fileName) {
        return "";
    }

    public void registerFileType(@NotNull FileType type, @NotNull List<? extends FileNameMatcher> defaultAssociations) {
    }

    public void fireFileTypesChanged() {
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        return this.fileType;
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        return this.fileType;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        return this.fileType;
    }

    public FileType @NotNull [] getRegisteredFileTypes() {
        return FileType.EMPTY_ARRAY;
    }

    public boolean isFileIgnored(@NotNull String name) {
        return false;
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        return false;
    }

    public String @NotNull [] getAssociatedExtensions(@NotNull FileType type) {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public void fireBeforeFileTypesChanged() {
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener) {
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener) {
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project2) {
        return file2.getFileType();
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        return Collections.emptyList();
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String fileTypeName) {
        if ("ARCHIVE".equals(fileTypeName)) {
            return UnknownFileType.INSTANCE;
        }
        if ("PLAIN_TEXT".equals(fileTypeName)) {
            return PlainTextFileType.INSTANCE;
        }
        if ("CLASS".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaClassFileType", fileTypeName);
        }
        if ("JAVA".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaFileType", fileTypeName);
        }
        if ("XML".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XmlFileType", fileTypeName);
        }
        if ("DTD".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.DTDFileType", fileTypeName);
        }
        if ("JSP".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.NewJspFileType", fileTypeName);
        }
        if ("JSPX".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JspxFileType", fileTypeName);
        }
        if ("HTML".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.HtmlFileType", fileTypeName);
        }
        if ("XHTML".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XHtmlFileType", fileTypeName);
        }
        if ("JavaScript".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.javascript.JavaScriptFileType", fileTypeName);
        }
        if ("Properties".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.properties.PropertiesFileType", fileTypeName);
        }
        if ("GUI_DESIGNER_FORM".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.uiDesigner.GuiFormFileType", fileTypeName);
        }
        return new MockLanguageFileType((Language)PlainTextLanguage.INSTANCE, StringUtil.toLowerCase((String)fileTypeName));
    }

    private static FileType loadFileTypeSafe(String className, String fileTypeName) {
        try {
            return (FileType)Class.forName(className).getField("INSTANCE").get(null);
        }
        catch (Exception ignored) {
            return new MockLanguageFileType((Language)PlainTextLanguage.INSTANCE, StringUtil.toLowerCase((String)fileTypeName));
        }
    }

    @Nullable
    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        return null;
    }
}

