/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ActionHint {
    @NotNull
    private final String myExpectedText;
    private final boolean myShouldPresent;
    private final ProblemHighlightType myHighlightType;
    private final boolean myExactMatch;

    private ActionHint(@NotNull String expectedText, boolean shouldPresent, ProblemHighlightType severity, boolean exactMatch) {
        this.myExpectedText = expectedText;
        this.myShouldPresent = shouldPresent;
        this.myHighlightType = severity;
        this.myExactMatch = exactMatch;
    }

    @NotNull
    public String getExpectedText() {
        return this.myExpectedText;
    }

    public boolean shouldPresent() {
        return this.myShouldPresent;
    }

    @Nullable
    public IntentionAction findAndCheck(@NotNull Collection<? extends IntentionAction> actions, @NotNull Supplier<String> infoSupplier) {
        IntentionAction result2 = actions.stream().filter(t -> {
            String text = t.getText();
            return this.myExactMatch ? text.equals(this.myExpectedText) : text.startsWith(this.myExpectedText);
        }).findFirst().orElse(null);
        if (this.myShouldPresent) {
            if (result2 == null) {
                Assert.fail((String)(this.exceptionHeader() + " not found\nAvailable actions: " + actions.stream().map(IntentionAction::getText).collect(Collectors.joining(", ", "[", "]\n")) + infoSupplier.get()));
            } else if (this.myHighlightType != null) {
                ProblemHighlightType actualType;
                if (!((result2 = IntentionActionDelegate.unwrap((IntentionAction)result2)) instanceof QuickFixWrapper)) {
                    Assert.fail((String)(this.exceptionHeader() + " is not a LocalQuickFix, but " + result2.getClass().getName() + "\nExpected LocalQuickFix with ProblemHighlightType=" + this.myHighlightType + "\n" + infoSupplier.get()));
                }
                if ((actualType = ((QuickFixWrapper)result2).getHighlightType()) != this.myHighlightType) {
                    Assert.fail((String)(this.exceptionHeader() + " has wrong ProblemHighlightType.\nExpected: " + this.myHighlightType + "\nActual: " + actualType + "\n" + infoSupplier.get()));
                }
            }
        } else if (result2 != null) {
            Assert.fail((String)(this.exceptionHeader() + " is present, but should not\n" + infoSupplier.get()));
        }
        return result2;
    }

    @NotNull
    private String exceptionHeader() {
        return "Action with " + (this.myExactMatch ? "text" : "prefix") + " '" + this.myExpectedText + "'";
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file2, @NotNull String contents) {
        return ActionHint.parse(file2, contents, true);
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file2, @NotNull String contents, boolean exactMatch) {
        PsiFile hostFile = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(hostFile.getLanguage());
        String comment = commenter.getLineCommentPrefix();
        if (comment == null) {
            comment = commenter.getBlockCommentPrefix();
        }
        assert (comment != null) : commenter;
        Pattern pattern = Pattern.compile("^" + Pattern.quote(comment) + " \"(.*)\" \"(\\w+)\".*", 32);
        Matcher matcher = pattern.matcher(contents);
        TestCase.assertTrue((String)("No comment found in " + file2.getVirtualFile()), (boolean)matcher.matches());
        String text = matcher.group(1);
        String state = matcher.group(2);
        if (state.equals("true") || state.equals("false")) {
            return new ActionHint(text, Boolean.parseBoolean(state), null, exactMatch);
        }
        return new ActionHint(text, true, ProblemHighlightType.valueOf((String)state), exactMatch);
    }
}

