/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.mvp;

import com.glavsoft.viewer.mvp.Model;
import com.glavsoft.viewer.mvp.PropertyNotFoundException;
import com.glavsoft.viewer.mvp.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Presenter {
    private final Map<String, View> registeredViews = new HashMap<String, View>();
    private final Map<String, Model> registeredModels = new HashMap<String, Model>();
    private static Logger logger = Logger.getLogger(Presenter.class.getName());
    private Throwable savedInvocationTargetException;

    public void addView(String name, View view) {
        this.registeredViews.put(name, view);
    }

    public void addModel(String name, Model model) {
        this.registeredModels.put(name, model);
    }

    protected void populate() {
        this.savedInvocationTargetException = null;
        for (Map.Entry<String, Model> entry : this.registeredModels.entrySet()) {
            String modelName = entry.getKey();
            Model model = entry.getValue();
            this.populateFrom(modelName, model);
        }
    }

    public void populateFrom(String modelName) {
        Model model = this.registeredModels.get(modelName);
        if (model != null) {
            this.populateFrom(modelName, model);
        } else {
            String string = String.valueOf(modelName);
            logger.finer(string.length() != 0 ? "Cannot find model: ".concat(string) : new String("Cannot find model: "));
        }
    }

    private void populateFrom(String modelName, Model model) {
        Method[] methods;
        for (Method m : methods = model.getClass().getDeclaredMethods()) {
            if (!m.getName().startsWith("get") || m.getParameterTypes().length != 0) continue;
            String propertyName = m.getName().substring(3);
            try {
                Object property = m.invoke((Object)model, new Object[0]);
                String string = String.valueOf(property);
                String string2 = String.valueOf(m.getReturnType());
                logger.finest(new StringBuilder(26 + String.valueOf(modelName).length() + String.valueOf(propertyName).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("Load: ").append(modelName).append(".get").append(propertyName).append("() # => ").append(string).append("  type: ").append(string2).toString());
                this.setViewProperty(propertyName, property, m.getReturnType());
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                this.savedInvocationTargetException = e.getCause();
                break;
            }
        }
    }

    protected boolean isModelRegisteredByName(String modelName) {
        return this.registeredModels.containsKey(modelName);
    }

    protected Model getModel(String modelName) {
        return this.registeredModels.get(modelName);
    }

    protected void show() {
        for (View v : this.registeredViews.values()) {
            v.showView();
        }
    }

    protected void save() {
        this.savedInvocationTargetException = null;
        block4: for (Map.Entry<String, Model> entry : this.registeredModels.entrySet()) {
            Method[] methods;
            String modelName = entry.getKey();
            Model model = entry.getValue();
            for (Method m : methods = model.getClass().getDeclaredMethods()) {
                if (!m.getName().startsWith("set")) continue;
                String propertyName = m.getName().substring(3);
                try {
                    Object viewProperty = this.getViewProperty(propertyName);
                    m.invoke((Object)model, viewProperty);
                    String string = String.valueOf(viewProperty);
                    logger.finest(new StringBuilder(14 + String.valueOf(modelName).length() + String.valueOf(propertyName).length() + String.valueOf(string).length()).append("Save: ").append(modelName).append(".set").append(propertyName).append("( ").append(string).append(" )").toString());
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    this.savedInvocationTargetException = e.getCause();
                    continue block4;
                }
                catch (PropertyNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }

    public Object getViewPropertyOrNull(String propertyName) {
        try {
            return this.getViewProperty(propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    public Object getViewProperty(String propertyName) throws PropertyNotFoundException {
        this.savedInvocationTargetException = null;
        logger.finest(new StringBuilder(5 + String.valueOf(propertyName).length()).append("get").append(propertyName).append("()").toString());
        for (Map.Entry<String, View> entry : this.registeredViews.entrySet()) {
            String viewName = entry.getKey();
            View view = entry.getValue();
            try {
                String string = String.valueOf(propertyName);
                Method getter = view.getClass().getMethod(string.length() != 0 ? "get".concat(string) : new String("get"), new Class[0]);
                Object res = getter.invoke((Object)view, new Object[0]);
                String string2 = String.valueOf(res);
                logger.finest(new StringBuilder(27 + String.valueOf(viewName).length() + String.valueOf(propertyName).length() + String.valueOf(string2).length()).append("----from view: ").append(viewName).append(".get").append(propertyName).append("() # +> ").append(string2).toString());
                return res;
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                this.savedInvocationTargetException = e.getCause();
                break;
            }
            catch (IllegalAccessException e) {
            }
        }
        throw new PropertyNotFoundException(propertyName);
    }

    public Object getModelProperty(String propertyName) {
        this.savedInvocationTargetException = null;
        logger.finest(new StringBuilder(5 + String.valueOf(propertyName).length()).append("get").append(propertyName).append("()").toString());
        for (String modelName : this.registeredModels.keySet()) {
            Model model = this.registeredModels.get(modelName);
            try {
                String string = String.valueOf(propertyName);
                Method getter = model.getClass().getMethod(string.length() != 0 ? "get".concat(string) : new String("get"), new Class[0]);
                Object res = getter.invoke((Object)model, new Object[0]);
                String string2 = String.valueOf(res);
                logger.finest(new StringBuilder(28 + String.valueOf(modelName).length() + String.valueOf(propertyName).length() + String.valueOf(string2).length()).append("----from model: ").append(modelName).append(".get").append(propertyName).append("() # +> ").append(string2).toString());
                return res;
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                this.savedInvocationTargetException = e.getCause();
                break;
            }
            catch (IllegalAccessException e) {
            }
        }
        return null;
    }

    public void setViewProperty(String propertyName, Object newValue) {
        this.setViewProperty(propertyName, newValue, newValue.getClass());
    }

    public void setViewProperty(String propertyName, Object newValue, Class<?> valueType) {
        this.savedInvocationTargetException = null;
        String string = String.valueOf(newValue);
        String string2 = String.valueOf(valueType);
        logger.finest(new StringBuilder(14 + String.valueOf(propertyName).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("set").append(propertyName).append("( ").append(string).append(" ) type: ").append(string2).toString());
        for (Map.Entry entry : this.registeredViews.entrySet()) {
            String viewName = (String)entry.getKey();
            View view = (View)entry.getValue();
            try {
                String string3 = String.valueOf(propertyName);
                Method setter = view.getClass().getMethod(string3.length() != 0 ? "set".concat(string3) : new String("set"), valueType);
                setter.invoke((Object)view, newValue);
                String string4 = String.valueOf(newValue);
                logger.finest(new StringBuilder(21 + String.valueOf(viewName).length() + String.valueOf(propertyName).length() + String.valueOf(string4).length()).append("----to view: ").append(viewName).append(".set").append(propertyName).append("( ").append(string4).append(" )").toString());
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
                this.savedInvocationTargetException = e.getCause();
                break;
            }
            catch (IllegalAccessException e) {
            }
        }
    }

    protected void throwPossiblyHappenedException() throws Throwable {
        if (this.savedInvocationTargetException != null) {
            Throwable tmp = this.savedInvocationTargetException;
            this.savedInvocationTargetException = null;
            throw tmp;
        }
    }

    protected View getView(String name) {
        return this.registeredViews.get(name);
    }

    public void setModelProperty(String propertyName, Object newValue) {
        this.setModelProperty(propertyName, newValue, newValue.getClass());
    }

    public void setModelProperty(String propertyName, Object newValue, Class<?> valueType) {
        this.savedInvocationTargetException = null;
        String string = String.valueOf(newValue);
        logger.finest(new StringBuilder(7 + String.valueOf(propertyName).length() + String.valueOf(string).length()).append("set").append(propertyName).append("( ").append(string).append(" )").toString());
        for (Map.Entry entry : this.registeredModels.entrySet()) {
            String modelName = (String)entry.getKey();
            Model model = (Model)entry.getValue();
            try {
                String string2 = String.valueOf(propertyName);
                Method method = model.getClass().getMethod(string2.length() != 0 ? "set".concat(string2) : new String("set"), valueType);
                method.invoke((Object)model, newValue);
                String string3 = String.valueOf(modelName);
                logger.finest(string3.length() != 0 ? "----for model: ".concat(string3) : new String("----for model: "));
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                this.savedInvocationTargetException = e.getCause();
                break;
            }
            catch (IllegalAccessException e) {
            }
        }
    }
}

