/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol.auth;

import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.RfbCapabilityInfo;
import com.glavsoft.rfb.encoding.ServerInitMessage;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.auth.AuthHandler;
import com.glavsoft.rfb.protocol.auth.SecurityType;
import com.glavsoft.rfb.protocol.tunnel.TunnelHandler;
import com.glavsoft.rfb.protocol.tunnel.TunnelType;
import com.glavsoft.transport.Transport;
import com.glavsoft.utils.Strings;
import java.util.HashMap;
import java.util.Map;

public class TightAuthentication
extends AuthHandler {
    private final Map<Integer, AuthHandler> registeredAuthHandlers = new HashMap<Integer, AuthHandler>();
    private final Map<Integer, TunnelHandler> registeredTunnelHandlers = new HashMap<Integer, TunnelHandler>();

    public void registerTunnelingHandler(TunnelHandler handler) {
        this.registeredTunnelHandlers.put(handler.getId(), handler);
    }

    public void registerAuthHandler(AuthHandler handler) {
        this.registeredAuthHandlers.put(handler.getId(), handler);
    }

    @Override
    public SecurityType getType() {
        return SecurityType.TIGHT_AUTHENTICATION;
    }

    @Override
    public Transport authenticate(Transport transport, Protocol protocol) throws TransportException, FatalException, UnsupportedSecurityTypeException {
        transport = this.tunnelingNegotiation(transport, protocol);
        this.authorizationNegotiation(transport, protocol);
        protocol.setTight(true);
        return transport;
    }

    @Override
    public void initProcedure(Transport transport, Protocol protocol) throws TransportException {
        this.capabilitiesNegotiation(transport, protocol);
    }

    void capabilitiesNegotiation(Transport transport, Protocol protocol) throws TransportException {
        this.sendClientInitMessage(transport, protocol.getSettings().getSharedFlag());
        ServerInitMessage serverInitMessage = this.readServerInitMessage(transport);
        int nServerMessageTypes = transport.readUInt16();
        int nClientMessageTypes = transport.readUInt16();
        int nEncodingTypes = transport.readUInt16();
        transport.readUInt16();
        this.logger().fine(new StringBuilder(95).append("nServerMessageTypes: ").append(nServerMessageTypes).append(", nClientMessageTypes: ").append(nClientMessageTypes).append(", nEncodingTypes: ").append(nEncodingTypes).toString());
        this.registerServerMessagesTypes(transport, protocol, nServerMessageTypes);
        this.registerClientMessagesTypes(transport, protocol, nClientMessageTypes);
        this.registerEncodings(transport, protocol, nEncodingTypes);
        this.completeContextData(serverInitMessage, protocol);
    }

    private void registerServerMessagesTypes(Transport transport, Protocol protocol, int count) throws TransportException {
        while (count-- > 0) {
            RfbCapabilityInfo capInfoReceived = new RfbCapabilityInfo().readFrom(transport);
            String string = String.valueOf(capInfoReceived.toString());
            this.logger().fine(string.length() != 0 ? "Server message type: ".concat(string) : new String("Server message type: "));
        }
    }

    private void registerClientMessagesTypes(Transport transport, Protocol protocol, int count) throws TransportException {
        while (count-- > 0) {
            RfbCapabilityInfo capInfoReceived = new RfbCapabilityInfo().readFrom(transport);
            String string = String.valueOf(capInfoReceived.toString());
            this.logger().fine(string.length() != 0 ? "Client message type: ".concat(string) : new String("Client message type: "));
            protocol.registerClientMessageType(capInfoReceived);
        }
    }

    private void registerEncodings(Transport transport, Protocol protocol, int count) throws TransportException {
        while (count-- > 0) {
            RfbCapabilityInfo capInfoReceived = new RfbCapabilityInfo().readFrom(transport);
            String string = String.valueOf(capInfoReceived.toString());
            this.logger().fine(string.length() != 0 ? "Encoding: ".concat(string) : new String("Encoding: "));
            protocol.registerEncoding(capInfoReceived);
        }
    }

    Transport tunnelingNegotiation(Transport transport, Protocol protocol) throws TransportException {
        Transport newTransport = transport;
        int tunnelsCount = (int)transport.readUInt32();
        this.logger().fine(new StringBuilder(35).append("Tunneling capabilities: ").append(tunnelsCount).toString());
        int[] tunnelCodes = new int[tunnelsCount];
        if (tunnelsCount > 0) {
            for (int i = 0; i < tunnelsCount; ++i) {
                RfbCapabilityInfo rfbCapabilityInfo = new RfbCapabilityInfo().readFrom(transport);
                tunnelCodes[i] = rfbCapabilityInfo.getCode();
                this.logger().fine(rfbCapabilityInfo.toString());
            }
            if (tunnelsCount > 0) {
                for (int i = 0; i < tunnelsCount; ++i) {
                    TunnelHandler tunnelHandler = this.registeredTunnelHandlers.get(tunnelCodes[i]);
                    if (tunnelHandler == null) continue;
                    int selectedTunnelCode = tunnelCodes[i];
                    transport.writeInt32(selectedTunnelCode).flush();
                    this.logger().fine(new StringBuilder(36).append("Accepted tunneling type: ").append(selectedTunnelCode).toString());
                    newTransport = tunnelHandler.createTunnel(transport);
                    String string = String.valueOf((Object)TunnelType.byCode(selectedTunnelCode));
                    this.logger().fine(new StringBuilder(16 + String.valueOf(string).length()).append("Tunnel created: ").append(string).toString());
                    protocol.setTunnelType(TunnelType.byCode(selectedTunnelCode));
                    break;
                }
            }
        }
        if (protocol.getTunnelType() == null) {
            protocol.setTunnelType(TunnelType.NOTUNNEL);
            if (tunnelsCount > 0) {
                transport.writeInt32(TunnelType.NOTUNNEL.code).flush();
            }
            String string = String.valueOf((Object)TunnelType.NOTUNNEL);
            this.logger().fine(new StringBuilder(25 + String.valueOf(string).length()).append("Accepted tunneling type: ").append(string).toString());
        }
        return newTransport;
    }

    void authorizationNegotiation(Transport transport, Protocol protocol) throws UnsupportedSecurityTypeException, TransportException, FatalException {
        int authCount = transport.readInt32();
        this.logger().fine(new StringBuilder(30).append("Auth capabilities: ").append(authCount).toString());
        byte[] cap = new byte[authCount];
        for (int i = 0; i < authCount; ++i) {
            RfbCapabilityInfo rfbCapabilityInfo = new RfbCapabilityInfo().readFrom(transport);
            cap[i] = (byte)rfbCapabilityInfo.getCode();
            this.logger().fine(rfbCapabilityInfo.toString());
        }
        AuthHandler authHandler = null;
        if (authCount > 0) {
            for (int i = 0; i < authCount; ++i) {
                authHandler = this.registeredAuthHandlers.get(cap[i]);
                if (authHandler == null) continue;
                transport.writeInt32(authHandler.getId()).flush();
                break;
            }
        } else {
            authHandler = this.registeredAuthHandlers.get(SecurityType.NONE_AUTHENTICATION.getId());
        }
        if (null == authHandler) {
            String string = Strings.toString(cap);
            String string2 = String.valueOf(this.registeredAuthHandlers.values());
            throw new UnsupportedSecurityTypeException(new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Server auth types: ").append(string).append(", supported auth types: ").append(string2).toString());
        }
        String string = String.valueOf(authHandler.getName());
        this.logger().fine(string.length() != 0 ? "Auth capability accepted: ".concat(string) : new String("Auth capability accepted: "));
        authHandler.authenticate(transport, protocol);
    }
}

