/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding.decoder;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.encoding.decoder.ZlibDecoder;
import com.glavsoft.transport.Transport;

public class ZRLEDecoder
extends ZlibDecoder {
    private static final int MAX_TILE_SIZE = 64;
    private int[] decodedBitmap;
    private int[] palette;

    @Override
    public void decode(Transport transport, Renderer renderer, FramebufferUpdateRectangle rect) throws TransportException {
        int zippedLength = (int)transport.readUInt32();
        if (0 == zippedLength) {
            return;
        }
        int length = rect.width * rect.height * renderer.getBytesPerCPixel() + (rect.width / 64 + 1) * (rect.height / 64 + 1);
        byte[] bytes = this.unzip(transport, zippedLength, length);
        int offset = zippedLength;
        int maxX = rect.x + rect.width;
        int maxY = rect.y + rect.height;
        if (null == this.palette) {
            this.palette = new int[128];
        }
        if (null == this.decodedBitmap) {
            this.decodedBitmap = new int[4096];
        }
        for (int tileY = rect.y; tileY < maxY; tileY += 64) {
            int tileHeight = Math.min(maxY - tileY, 64);
            for (int tileX = rect.x; tileX < maxX; tileX += 64) {
                int subencoding;
                int tileWidth = Math.min(maxX - tileX, 64);
                boolean isRle = ((subencoding = bytes[offset++] & 0xFF) & 0x80) != 0;
                int paletteSize = subencoding & 0x7F;
                offset += this.readPalette(bytes, offset, renderer, paletteSize);
                if (1 == subencoding) {
                    renderer.fillRect(this.palette[0], tileX, tileY, tileWidth, tileHeight);
                    continue;
                }
                if (isRle) {
                    if (0 == paletteSize) {
                        offset += this.decodePlainRle(bytes, offset, renderer, tileX, tileY, tileWidth, tileHeight);
                        continue;
                    }
                    offset += this.decodePaletteRle(bytes, offset, renderer, tileX, tileY, tileWidth, tileHeight);
                    continue;
                }
                if (0 == paletteSize) {
                    offset += this.decodeRaw(bytes, offset, renderer, tileX, tileY, tileWidth, tileHeight);
                    continue;
                }
                offset += this.decodePacked(bytes, offset, renderer, paletteSize, tileX, tileY, tileWidth, tileHeight);
            }
        }
    }

    private int decodePlainRle(byte[] bytes, int offset, Renderer renderer, int tileX, int tileY, int tileWidth, int tileHeight) {
        int rlength;
        int bytesPerCPixel = renderer.getBytesPerCPixel();
        int decodedEnd = tileWidth * tileHeight;
        int index = offset;
        for (int decodedOffset = 0; decodedOffset < decodedEnd; decodedOffset += rlength) {
            int color = renderer.getCompactPixelColor(bytes, index);
            index += bytesPerCPixel;
            rlength = 1;
            do {
                rlength += bytes[index] & 0xFF;
            } while ((bytes[index++] & 0xFF) == 255);
            assert (rlength <= decodedEnd - decodedOffset);
            renderer.fillColorBitmapWithColor(this.decodedBitmap, decodedOffset, rlength, color);
        }
        renderer.drawColoredBitmap(this.decodedBitmap, tileX, tileY, tileWidth, tileHeight);
        return index - offset;
    }

    private int decodePaletteRle(byte[] bytes, int offset, Renderer renderer, int tileX, int tileY, int tileWidth, int tileHeight) {
        int rlength;
        int decodedEnd = tileWidth * tileHeight;
        int index = offset;
        for (int decodedOffset = 0; decodedOffset < decodedEnd; decodedOffset += rlength) {
            byte colorIndex = bytes[index++];
            int color = this.palette[colorIndex & 0x7F];
            rlength = 1;
            if ((colorIndex & 0x80) != 0) {
                do {
                    rlength += bytes[index] & 0xFF;
                } while (bytes[index++] == -1);
            }
            assert (rlength <= decodedEnd - decodedOffset);
            renderer.fillColorBitmapWithColor(this.decodedBitmap, decodedOffset, rlength, color);
        }
        renderer.drawColoredBitmap(this.decodedBitmap, tileX, tileY, tileWidth, tileHeight);
        return index - offset;
    }

    private int decodePacked(byte[] bytes, int offset, Renderer renderer, int paletteSize, int tileX, int tileY, int tileWidth, int tileHeight) {
        int bitsPerPalletedPixel = paletteSize > 16 ? 8 : (paletteSize > 4 ? 4 : (paletteSize > 2 ? 2 : 1));
        int packedOffset = offset;
        int decodedOffset = 0;
        for (int i = 0; i < tileHeight; ++i) {
            int decodedRowEnd = decodedOffset + tileWidth;
            byte byteProcessed = 0;
            int bitsRemain = 0;
            while (decodedOffset < decodedRowEnd) {
                if (bitsRemain == 0) {
                    byteProcessed = bytes[packedOffset++];
                    bitsRemain = 8;
                }
                int index = byteProcessed >> (bitsRemain -= bitsPerPalletedPixel) & (1 << bitsPerPalletedPixel) - 1 & 0x7F;
                int color = this.palette[index];
                renderer.fillColorBitmapWithColor(this.decodedBitmap, decodedOffset, 1, color);
                ++decodedOffset;
            }
        }
        renderer.drawColoredBitmap(this.decodedBitmap, tileX, tileY, tileWidth, tileHeight);
        return packedOffset - offset;
    }

    private int decodeRaw(byte[] bytes, int offset, Renderer renderer, int tileX, int tileY, int tileWidth, int tileHeight) throws TransportException {
        return renderer.drawCompactBytes(bytes, offset, tileX, tileY, tileWidth, tileHeight);
    }

    private int readPalette(byte[] bytes, int offset, Renderer renderer, int paletteSize) {
        int bytesPerCPixel = renderer.getBytesPerCPixel();
        for (int i = 0; i < paletteSize; ++i) {
            this.palette[i] = renderer.getCompactPixelColor(bytes, offset + i * bytesPerCPixel);
        }
        return paletteSize * bytesPerCPixel;
    }
}

