/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private final int myStart;
    private final int myEnd;
    private transient int hash;
    private final byte[] myChars;

    public ByteArrayCharSequence(byte @NotNull [] chars) {
        this(chars, 0, chars.length);
    }

    public ByteArrayCharSequence(byte @NotNull [] chars, int start, int end) {
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode(this, this.myStart, this.myEnd);
        }
        return h;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return (char)(this.myChars[index + this.myStart] & 0xFF);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new CharSequenceSubSequence(this, start, end);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.length(), StandardCharsets.ISO_8859_1);
    }

    @Deprecated
    @NotNull
    public static CharSequence convertToBytesIfAsciiString(@NotNull String name) {
        return ByteArrayCharSequence.convertToBytesIfPossible(name);
    }

    @NotNull
    public static CharSequence convertToBytesIfPossible(@NotNull CharSequence string) {
        if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        if (string instanceof ByteArrayCharSequence) {
            return string;
        }
        byte[] bytes = ByteArrayCharSequence.toBytesIfPossible(string);
        return bytes == null ? string : new ByteArrayCharSequence(bytes);
    }

    byte @NotNull [] getBytes() {
        return this.myStart == 0 && this.myEnd == this.myChars.length ? this.myChars : Arrays.copyOfRange(this.myChars, this.myStart, this.myEnd);
    }

    static byte @Nullable [] toBytesIfPossible(@NotNull CharSequence seq) {
        if (seq instanceof ByteArrayCharSequence) {
            return ((ByteArrayCharSequence)seq).getBytes();
        }
        byte[] bytes = new byte[seq.length()];
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(seq);
        if (chars == null) {
            for (int i = 0; i < bytes.length; ++i) {
                char c = seq.charAt(i);
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        } else {
            for (int i = 0; i < bytes.length; ++i) {
                char c = chars[i];
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        }
        return bytes;
    }
}

