/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.reference.SoftReference;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ref.GCUtil;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GCWatcher {
    private final ReferenceQueue<Object> myQueue = new ReferenceQueue();
    private final Set<Reference<?>> myReferences = ContainerUtil.newConcurrentSet();

    private GCWatcher(@NotNull Collection<?> objects) {
        for (Object o : objects) {
            if (o == null) continue;
            this.myReferences.add(new WeakReference<Object>(o, this.myQueue));
        }
    }

    @NotNull
    @Contract(pure=true)
    public static GCWatcher tracking(Object ... objects) {
        return GCWatcher.tracking(Arrays.asList(objects));
    }

    @NotNull
    @Contract(pure=true)
    public static GCWatcher tracking(@NotNull Collection<?> objects) {
        return new GCWatcher(objects);
    }

    @NotNull
    public static GCWatcher fromClearedRef(@NotNull Ref<?> ref) {
        GCWatcher result = GCWatcher.tracking(ref.get());
        ref.set(null);
        return result;
    }

    private boolean isEverythingCollected() {
        boolean removed;
        while (true) {
            Reference<Object> ref;
            if ((ref = this.myQueue.poll()) == null) {
                return this.myReferences.isEmpty();
            }
            removed = this.myReferences.remove(ref);
            assert (removed);
        }
    }

    public boolean tryCollect(int timeoutMs) {
        return LowMemoryWatcher.runWithNotificationsSuppressed(() -> {
            long startTime = System.currentTimeMillis();
            GCUtil.allocateTonsOfMemory(new StringBuilder(), () -> this.isEverythingCollected() || System.currentTimeMillis() - startTime > (long)timeoutMs);
            return this.isEverythingCollected();
        });
    }

    public void ensureCollected() {
        StringBuilder log = new StringBuilder();
        if (!GCUtil.allocateTonsOfMemory(log, this::isEverythingCollected)) {
            String message = "Couldn't garbage-collect some objects, they might still be reachable from GC roots: " + ContainerUtil.mapNotNull(this.myReferences, SoftReference::dereference);
            try {
                File file = new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), "GCWatcher.hprof.zip");
                MemoryDumpHelper.captureMemoryDumpZipped(file);
                System.out.println("##teamcity[publishArtifacts '" + file.getPath() + "']");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.isEverythingCollected()) {
                message = message + "\nEverything is collected after taking the heap dump.";
            }
            message = message + "Log:\n" + log;
            throw new IllegalStateException(message);
        }
    }
}

