/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.loader;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class NativeLibraryLoader {
    public static void loadPlatformLibrary(@NotNull String libName) {
        String libPath;
        String libFileName = NativeLibraryLoader.mapLibraryName(libName);
        Path libFile = PathManager.findBinFile(libFileName);
        if (libFile != null) {
            libPath = libFile.toAbsolutePath().toString();
        } else {
            libPath = PathManager.getHomePathFor(IdeaWin32.class) + "/bin/" + libFileName;
            if (!Files.exists(Paths.get(libPath, new String[0]), new LinkOption[0])) {
                File libDir = new File(PathManager.getBinPath());
                throw new UnsatisfiedLinkError("'" + libFileName + "' not found in '" + libDir + "' among " + Arrays.toString(libDir.list()));
            }
        }
        System.load(libPath);
    }

    @NotNull
    private static String mapLibraryName(@NotNull String libName) {
        String baseName = libName;
        if (SystemInfoRt.is64Bit) {
            baseName = baseName.replace("32", "") + "64";
        }
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfoRt.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        return fileName;
    }
}

