/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.MemoryResource;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.SecureJarLoader;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassPath {
    private static final ResourceStringLoaderIterator ourResourceIterator = new ResourceStringLoaderIterator();
    private static final LoaderCollector ourLoaderCollector = new LoaderCollector();
    public static final String CLASSPATH_JAR_FILE_NAME_PREFIX = "classpath";
    private final List<URL> myUrls = new ArrayList<URL>();
    private final List<Loader> myLoaders = new ArrayList<Loader>();
    private volatile boolean myAllUrlsWereProcessed;
    private final AtomicInteger myLastLoaderProcessed = new AtomicInteger();
    private final Map<URL, Loader> myLoadersMap = new HashMap<URL, Loader>();
    private final ClasspathCache myCache = new ClasspathCache();
    private final Set<URL> myURLsWithProtectionDomain;
    final boolean myCanLockJars;
    private final boolean myCanUseCache;
    private final boolean myAcceptUnescapedUrls;
    final boolean myPreloadJarContents;
    final boolean myCanHavePersistentIndex;
    final boolean myLazyClassloadingCaches;
    @Nullable
    private final CachePoolImpl myCachePool;
    @Nullable
    private final UrlClassLoader.CachingCondition myCachingCondition;
    final boolean myLogErrorOnMissingJar;
    @Nullable
    private final LinkedHashSet<String> myJarAccessLog;
    private static final ResourceLoadingLogger ourResourceLoadingLogger;
    static final boolean ourClassLoadingInfo;
    private static final Set<String> ourLoadedClasses;
    private static final AtomicLong ourTotalTime;
    private static final AtomicInteger ourTotalRequests;
    private static final ThreadLocal<Boolean> ourDoingTiming;

    public ClassPath(List<URL> urls, boolean canLockJars, boolean canUseCache, boolean acceptUnescapedUrls, boolean preloadJarContents, boolean canHavePersistentIndex, @Nullable CachePoolImpl cachePool, @Nullable UrlClassLoader.CachingCondition cachingCondition, boolean logErrorOnMissingJar, boolean lazyClassloadingCaches, @NotNull Set<URL> urlsWithProtectionDomain, boolean logJarAccess) {
        this.myLazyClassloadingCaches = lazyClassloadingCaches;
        this.myCanLockJars = canLockJars;
        this.myCanUseCache = canUseCache && !this.myLazyClassloadingCaches;
        this.myAcceptUnescapedUrls = acceptUnescapedUrls;
        this.myPreloadJarContents = preloadJarContents;
        this.myCachePool = cachePool;
        this.myCachingCondition = cachingCondition;
        this.myCanHavePersistentIndex = canHavePersistentIndex;
        this.myLogErrorOnMissingJar = logErrorOnMissingJar;
        this.myURLsWithProtectionDomain = urlsWithProtectionDomain;
        this.myJarAccessLog = logJarAccess ? new LinkedHashSet() : null;
        this.push(urls);
    }

    @Deprecated
    void addURL(URL url) {
        this.push(Collections.singletonList(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(List<URL> urls) {
        if (!urls.isEmpty()) {
            List<URL> list = this.myUrls;
            synchronized (list) {
                for (int i = urls.size() - 1; i >= 0; --i) {
                    this.myUrls.add(urls.get(i));
                }
                this.myAllUrlsWereProcessed = false;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Resource getResource(@NotNull String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Enumeration<URL> getResources(String name) {
        return new MyEnumeration(name);
    }

    @Nullable
    private Loader getLoader(int i) {
        if (i < this.myLastLoaderProcessed.get()) {
            return this.myLoaders.get(i);
        }
        return this.getLoaderSlowPath(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoaderSlowPath(int i) {
        while (this.myLoaders.size() < i + 1) {
            URL url;
            List<URL> list = this.myUrls;
            synchronized (list) {
                int size = this.myUrls.size();
                if (size == 0) {
                    if (this.myCanUseCache) {
                        this.myAllUrlsWereProcessed = true;
                    }
                    return null;
                }
                url = this.myUrls.remove(size - 1);
            }
            if (this.myLoadersMap.containsKey(url)) continue;
            try {
                this.initLoaders(url, this.myLoaders.size());
            }
            catch (IOException e) {
                LoggerRt.getInstance(ClassPath.class).info("url: " + url, e);
            }
        }
        return this.myLoaders.get(i);
    }

    @NotNull
    public List<URL> getBaseUrls() {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Loader loader : this.myLoaders) {
            result.add(loader.getBaseURL());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<String> getJarAccessLog() {
        if (this.myJarAccessLog == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = this.myJarAccessLog;
        synchronized (linkedHashSet) {
            return new LinkedHashSet<String>(this.myJarAccessLog);
        }
    }

    private void initLoaders(@NotNull URL url, int index) throws IOException {
        File file;
        Loader loader;
        String path;
        if (this.myAcceptUnescapedUrls) {
            path = url.getFile();
        } else {
            try {
                path = url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                LoggerRt.getInstance(ClassPath.class).error("url: " + url, e);
                path = url.getFile();
            }
        }
        if (path != null && "file".equals(url.getProtocol()) && (loader = this.createLoader(url, index, file = new File(path), file.getName().startsWith(CLASSPATH_JAR_FILE_NAME_PREFIX))) != null) {
            this.initLoader(url, loader);
        }
    }

    private Loader createLoader(@NotNull URL url, int index, @NotNull File file, boolean processRecursively) throws IOException {
        if (file.isDirectory()) {
            return new FileLoader(url, index, this);
        }
        if (file.isFile()) {
            String[] referencedJars;
            JarLoader loader;
            boolean isSigned = this.myURLsWithProtectionDomain.contains(url);
            JarLoader jarLoader = loader = isSigned ? new SecureJarLoader(url, file.getPath(), index, this) : new JarLoader(url, file.getPath(), index, this);
            if (processRecursively && (referencedJars = ClassPath.loadManifestClasspath(loader)) != null) {
                long s2 = ourClassLoadingInfo ? System.nanoTime() : 0L;
                ArrayList<URL> urls = new ArrayList<URL>(referencedJars.length);
                for (String referencedJar : referencedJars) {
                    try {
                        urls.add(UrlClassLoader.internProtocol(new URI(referencedJar).toURL()));
                    }
                    catch (Exception e) {
                        LoggerRt.getInstance(ClassPath.class).warn("url: " + url + " / " + referencedJar, e);
                    }
                }
                this.push(urls);
                if (ourClassLoadingInfo) {
                    System.out.println("Loaded all " + referencedJars.length + " urls " + (System.nanoTime() - s2) / 1000000L + "ms");
                }
            }
            return loader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLoader(@NotNull URL url, @NotNull Loader loader) throws IOException {
        if (this.myCanUseCache) {
            boolean lastOne;
            ClasspathCache.LoaderData data;
            ClasspathCache.LoaderData loaderData = data = this.myCachePool == null ? null : this.myCachePool.getCachedData(url);
            if (data == null) {
                data = loader.buildData();
                if (this.myCachePool != null && this.myCachingCondition != null && this.myCachingCondition.shouldCacheData(url)) {
                    this.myCachePool.cacheData(url, data);
                }
            }
            this.myCache.applyLoaderData(data, loader);
            List<URL> list = this.myUrls;
            synchronized (list) {
                lastOne = this.myUrls.isEmpty();
            }
            if (lastOne) {
                this.myAllUrlsWereProcessed = true;
            }
        }
        this.myLoaders.add(loader);
        this.myLoadersMap.put(url, loader);
        this.myLastLoaderProcessed.incrementAndGet();
    }

    Attributes getManifestData(@NotNull URL url) {
        return this.myCanUseCache && this.myCachePool != null ? this.myCachePool.getManifestData(url) : null;
    }

    void cacheManifestData(@NotNull URL url, @NotNull Attributes manifestAttributes) {
        if (this.myCanUseCache && this.myCachePool != null && this.myCachingCondition != null && this.myCachingCondition.shouldCacheData(url)) {
            this.myCachePool.cacheManifestData(url, manifestAttributes);
        }
    }

    private static long startTiming() {
        if (!ourClassLoadingInfo) {
            return 0L;
        }
        if (ourDoingTiming.get() != null) {
            return 0L;
        }
        ourDoingTiming.set(Boolean.TRUE);
        return System.nanoTime();
    }

    private static void logInfo(ClassPath path, long started, String resourceName, Resource resource) {
        if (!ourClassLoadingInfo) {
            return;
        }
        if (resource != null) {
            String urlPath = resource.getURL().getPath();
            if (urlPath.endsWith(resourceName)) {
                String modulePath = urlPath.substring(0, urlPath.length() - resourceName.length());
                if (modulePath.startsWith("file:")) {
                    modulePath = modulePath.substring("file:".length());
                }
                if (modulePath.endsWith("/")) {
                    modulePath = modulePath.substring(0, modulePath.length() - 1);
                }
                if (modulePath.endsWith("!")) {
                    modulePath = modulePath.substring(0, modulePath.length() - 1);
                }
                urlPath = resourceName + ":" + modulePath;
            }
            ourLoadedClasses.add(urlPath);
        }
        if (started == 0L) {
            return;
        }
        ourDoingTiming.set(null);
        long time = System.nanoTime() - started;
        long totalTime = ourTotalTime.addAndGet(time);
        int totalRequests = ourTotalRequests.incrementAndGet();
        if (time > 3000000L) {
            System.out.println(time / 1000000L + " ms for " + resourceName);
        }
        if (totalRequests % 10000 == 0) {
            System.out.println(path.getClass().getClassLoader() + ", requests:" + ourTotalRequests + ", time:" + totalTime / 1000000L + "ms");
        }
    }

    private static String[] loadManifestClasspath(JarLoader loader) {
        try {
            String[] urls;
            String classPath = loader.getClassPathManifestAttribute();
            if (classPath != null && (urls = classPath.split(" ")).length > 0 && urls[0].startsWith("file:")) {
                return urls;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        String className = System.getProperty("intellij.class.resources.loading.logger");
        ResourceLoadingLogger resourceLoadingLogger = null;
        if (className != null) {
            try {
                resourceLoadingLogger = (ResourceLoadingLogger)Class.forName(className).newInstance();
            }
            catch (Throwable e) {
                LoggerRt.getInstance(ClassPath.class).error("Failed to instantiate resource loading logger " + className, e);
            }
        }
        ourResourceLoadingLogger = resourceLoadingLogger;
        ourClassLoadingInfo = Boolean.getBoolean("idea.log.classpath.info");
        ourLoadedClasses = ourClassLoadingInfo ? Collections.synchronizedSet(new LinkedHashSet()) : null;
        ourTotalTime = new AtomicLong();
        ourTotalRequests = new AtomicInteger();
        ourDoingTiming = new ThreadLocal();
        if (ourClassLoadingInfo) {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook for tracing classloading information"){

                @Override
                public void run() {
                    System.out.println("Classloading requests:" + ClassPath.class.getClassLoader() + "," + ourTotalRequests + ", time:" + ourTotalTime.get() / 1000000L + "ms");
                }
            });
        }
    }

    public static interface ResourceLoadingLogger {
        public void logResource(String var1, URL var2, long var3);
    }

    private static class LoaderCollector
    extends ClasspathCache.LoaderIterator<Object, Collection<Loader>, Object> {
        private LoaderCollector() {
        }

        @Override
        Object process(@NotNull Loader loader, @NotNull Collection<Loader> parameter, @NotNull Object parameter2, @NotNull String shortName) {
            parameter.add(loader);
            return null;
        }
    }

    private static final class ResourceStringLoaderIterator
    extends ClasspathCache.LoaderIterator<Resource, String, ClassPath> {
        private ResourceStringLoaderIterator() {
        }

        @Override
        Resource process(@NotNull Loader loader, @NotNull String s, @NotNull ClassPath classPath, @NotNull String shortName) {
            return loader.containsName(s, shortName) ? ResourceStringLoaderIterator.findInLoader(loader, s, classPath) : null;
        }

        @Nullable
        private static Resource findInLoader(@NotNull Loader loader, @NotNull String s, @NotNull ClassPath classPath) {
            Resource resource = loader.getResource(s);
            if (resource != null) {
                ResourceStringLoaderIterator.logFoundResource(loader, s, classPath, resource);
            }
            return resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void logFoundResource(@NotNull Loader loader, @NotNull String s, @NotNull ClassPath classPath, @NotNull Resource resource) {
            if (classPath.myJarAccessLog != null) {
                LinkedHashSet linkedHashSet = classPath.myJarAccessLog;
                synchronized (linkedHashSet) {
                    classPath.myJarAccessLog.add(loader.getBaseURL().toString());
                }
            }
            if (ourResourceLoadingLogger != null) {
                long resourceSize;
                try {
                    resourceSize = resource instanceof MemoryResource ? (long)resource.getBytes().length : -1L;
                }
                catch (IOException e) {
                    resourceSize = -1L;
                }
                ourResourceLoadingLogger.logResource(s, loader.getBaseURL(), resourceSize);
            }
        }
    }

    private final class MyEnumeration
    implements Enumeration<URL> {
        private int myIndex;
        private Resource myRes;
        @NotNull
        private final String myName;
        private final String myShortName;
        private final List<Loader> myLoaders;

        MyEnumeration(String name) {
            this.myName = name;
            this.myShortName = ClasspathCache.transformName(name);
            ArrayList loaders = null;
            if (ClassPath.this.myCanUseCache && ClassPath.this.myAllUrlsWereProcessed) {
                LinkedHashSet loadersSet = new LinkedHashSet();
                ClassPath.this.myCache.iterateLoaders(name, ourLoaderCollector, loadersSet, this, this.myShortName);
                if (name.endsWith("/")) {
                    ClassPath.this.myCache.iterateLoaders(name.substring(0, name.length() - 1), ourLoaderCollector, loadersSet, this, this.myShortName);
                } else {
                    ClassPath.this.myCache.iterateLoaders(name + "/", ourLoaderCollector, loadersSet, this, this.myShortName);
                }
                loaders = new ArrayList(loadersSet);
            }
            this.myLoaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.myRes != null) {
                return true;
            }
            long started = ClassPath.startTiming();
            try {
                if (this.myLoaders != null) {
                    while (this.myIndex < this.myLoaders.size()) {
                        Loader loader;
                        if (!(loader = this.myLoaders.get(this.myIndex++)).containsName(this.myName, this.myShortName)) {
                            this.myRes = null;
                            continue;
                        }
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    Loader loader;
                    while ((loader = ClassPath.this.getLoader(this.myIndex++)) != null) {
                        if (ClassPath.this.myCanUseCache && !loader.containsName(this.myName, this.myShortName)) continue;
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                ClassPath.logInfo(ClassPath.this, started, this.myName, null);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.myRes;
            this.myRes = null;
            return resource.getURL();
        }
    }
}

