/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class StorageLockContext {
    private final boolean myCheckThreadAccess;
    @NotNull
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    @NotNull
    private final StorageLock myStorageLock;
    private final boolean myUseReadWriteLock;

    public StorageLockContext(@NotNull StorageLock lock, boolean checkAccess, boolean useReadWriteLock) {
        this.myStorageLock = lock;
        this.myCheckThreadAccess = checkAccess;
        this.myUseReadWriteLock = useReadWriteLock;
    }

    public StorageLockContext(boolean checkAccess, boolean useReadWriteLock) {
        this(PagedFileStorage.ourLock, checkAccess, useReadWriteLock);
    }

    public StorageLockContext(boolean checkAccess) {
        this(PagedFileStorage.ourLock, checkAccess, false);
    }

    public void lockRead() {
        if (this.myUseReadWriteLock) {
            this.myLock.readLock().lock();
        } else {
            this.myLock.writeLock().lock();
        }
    }

    public void unlockRead() {
        if (this.myUseReadWriteLock) {
            this.myLock.readLock().unlock();
        } else {
            this.myLock.writeLock().unlock();
        }
    }

    public void lockWrite() {
        this.myLock.writeLock().lock();
    }

    public void unlockWrite() {
        this.myLock.writeLock().unlock();
    }

    @ApiStatus.Internal
    @NotNull
    StorageLock getStorageLock() {
        return this.myStorageLock;
    }

    @ApiStatus.Internal
    void checkThreadAccess(boolean read) {
        if (this.myCheckThreadAccess) {
            if (read) {
                if (this.myLock.getReadHoldCount() > 0 || this.myLock.writeLock().isHeldByCurrentThread()) {
                    return;
                }
                throw new IllegalStateException("Must hold StorageLock read lock to access PagedFileStorage");
            }
            if (this.myLock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            throw new IllegalStateException("Must hold StorageLock write lock to access PagedFileStorage");
        }
    }
}

