/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.FileChannelUtil;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class OpenChannelsCache {
    private final int myCacheSizeLimit;
    @NotNull
    private final Set<StandardOpenOption> myOpenOptions;
    @NotNull
    private final Map<Path, ChannelDescriptor> myCache;
    private final Object myLock = new Object();

    OpenChannelsCache(int cacheSizeLimit, @NotNull Set<StandardOpenOption> openOptions) {
        this.myCacheSizeLimit = cacheSizeLimit;
        this.myOpenOptions = openOptions;
        this.myCache = new LinkedHashMap<Path, ChannelDescriptor>(cacheSizeLimit, 0.5f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T useChannel(@NotNull Path path, @NotNull ChannelProcessor<T> processor) throws IOException {
        ChannelDescriptor descriptor;
        Object object = this.myLock;
        synchronized (object) {
            descriptor = this.myCache.get(path);
            if (descriptor == null) {
                this.releaseOverCachedChannels();
                descriptor = new ChannelDescriptor(path, this.myOpenOptions);
                this.myCache.put(path, descriptor);
            }
            descriptor.lock();
        }
        try {
            object = processor.process(descriptor.getChannel());
            return (T)object;
        }
        finally {
            Object object2 = this.myLock;
            synchronized (object2) {
                descriptor.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeChannel(Path path) {
        Object object = this.myLock;
        synchronized (object) {
            ChannelDescriptor descriptor = this.myCache.remove(path);
            if (descriptor != null) {
                assert (!descriptor.isLocked());
                try {
                    descriptor.getChannel().close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void releaseOverCachedChannels() {
        int dropCount = this.myCache.size() - this.myCacheSizeLimit;
        if (dropCount >= 0) {
            ArrayList<Path> keysToDrop = new ArrayList<Path>();
            for (Map.Entry<Path, ChannelDescriptor> entry : this.myCache.entrySet()) {
                if (dropCount < 0) break;
                if (entry.getValue().isLocked()) continue;
                --dropCount;
                keysToDrop.add(entry.getKey());
            }
            for (Path file : keysToDrop) {
                this.closeChannel(file);
            }
        }
    }

    private static class ChannelDescriptor {
        private int lockCount = 0;
        private final FileChannel myChannel;

        ChannelDescriptor(@NotNull Path file, @NotNull Set<? extends OpenOption> accessMode) throws IOException {
            this.myChannel = FileChannelUtil.unInterruptible(FileChannel.open(file, accessMode, new FileAttribute[0]));
        }

        void lock() {
            ++this.lockCount;
        }

        void unlock() {
            --this.lockCount;
        }

        boolean isLocked() {
            return this.lockCount != 0;
        }

        FileChannel getChannel() {
            return this.myChannel;
        }
    }

    @FunctionalInterface
    static interface ChannelProcessor<T> {
        public T process(@NotNull FileChannel var1) throws IOException;
    }
}

