/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.io.ByteSequenceDataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentMapBasedForwardIndex
implements ForwardIndex {
    @NotNull
    private volatile PersistentHashMap<Integer, ByteArraySequence> myPersistentMap;
    @NotNull
    private final Path myMapFile;
    private final boolean myUseChunks;
    private final boolean myReadOnly;

    public PersistentMapBasedForwardIndex(@NotNull Path mapFile, boolean isReadOnly) throws IOException {
        this(mapFile, true, isReadOnly);
    }

    public PersistentMapBasedForwardIndex(@NotNull Path mapFile, boolean useChunks, boolean isReadOnly) throws IOException {
        this.myPersistentMap = PersistentMapBasedForwardIndex.createMap(mapFile, useChunks, isReadOnly);
        this.myMapFile = mapFile;
        this.myUseChunks = useChunks;
        this.myReadOnly = isReadOnly;
    }

    @Override
    @Nullable
    public ByteArraySequence get(@NotNull Integer key) throws IOException {
        return this.myPersistentMap.get(key);
    }

    @Override
    public void put(@NotNull Integer key, @Nullable ByteArraySequence value) throws IOException {
        if (value == null) {
            this.myPersistentMap.remove(key);
        } else {
            this.myPersistentMap.put(key, value);
        }
    }

    @Override
    public void force() {
        this.myPersistentMap.force();
    }

    @Override
    public void clear() throws IOException {
        PersistentHashMap.deleteMap(this.myPersistentMap);
        this.myPersistentMap = PersistentMapBasedForwardIndex.createMap(this.myMapFile, this.myUseChunks, this.myReadOnly);
    }

    @Override
    public void close() throws IOException {
        this.myPersistentMap.close();
    }

    public boolean containsMapping(int key) throws IOException {
        return this.myPersistentMap.containsMapping(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PersistentHashMap<Integer, ByteArraySequence> createMap(@NotNull Path file, boolean useChunks, boolean isReadOnly) throws IOException {
        Boolean oldHasNoChunksValue = PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.get();
        PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(!useChunks);
        Boolean previousReadOnly = PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get();
        PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(isReadOnly);
        try {
            PersistentHashMap<Integer, ByteArraySequence> persistentHashMap = new PersistentHashMap<Integer, ByteArraySequence>(file, EnumeratorIntegerDescriptor.INSTANCE, ByteSequenceDataExternalizer.INSTANCE);
            return persistentHashMap;
        }
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(oldHasNoChunksValue);
            PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(previousReadOnly);
        }
    }
}

