/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.Interner;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HashSetInterner<T>
extends Interner<T> {
    private final ObjectOpenHashSet<T> mySet;

    public HashSetInterner() {
        this.mySet = new ObjectOpenHashSet();
    }

    public HashSetInterner(@NotNull Collection<? extends T> initialItems) {
        this.mySet = new ObjectOpenHashSet(initialItems);
    }

    @Override
    @NotNull
    public T intern(@NotNull T name) {
        return (T)this.mySet.addOrGet(name);
    }

    @Override
    public void clear() {
        this.mySet.clear();
    }

    @Override
    @NotNull
    public Set<T> getValues() {
        return this.mySet;
    }
}

