/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import org.jetbrains.annotations.NotNull;

public class Enumerator<T> {
    private static final Logger LOG = Logger.getInstance(Enumerator.class);
    private final TObjectIntHashMap<T> myNumbers;
    private int myNextNumber = 1;

    public Enumerator(int expectNumber, @NotNull TObjectHashingStrategy<T> strategy) {
        this.myNumbers = new TObjectIntHashMap(expectNumber, strategy);
    }

    public void clear() {
        this.myNumbers.clear();
        this.myNextNumber = 1;
    }

    public int @NotNull [] enumerate(T @NotNull [] objects) {
        return this.enumerate(objects, 0, 0);
    }

    public int @NotNull [] enumerate(T @NotNull [] objects, int startShift, int endCut) {
        int[] idx = ArrayUtil.newIntArray(objects.length - startShift - endCut);
        for (int i = startShift; i < objects.length - endCut; ++i) {
            int number;
            T object = objects[i];
            idx[i - startShift] = number = this.enumerate(object);
        }
        return idx;
    }

    public int enumerate(T object) {
        int res = this.enumerateImpl(object);
        return Math.max(res, -res);
    }

    public boolean add(T object) {
        int res = this.enumerateImpl(object);
        return res < 0;
    }

    public int enumerateImpl(T object) {
        if (object == null) {
            return 0;
        }
        int number = this.myNumbers.get(object);
        if (number == 0) {
            number = this.myNextNumber++;
            this.myNumbers.put(object, number);
            return -number;
        }
        return number;
    }

    public boolean contains(@NotNull T object) {
        return this.myNumbers.get(object) != 0;
    }

    public int get(T object) {
        if (object == null) {
            return 0;
        }
        int res = this.myNumbers.get(object);
        if (res == 0) {
            LOG.error("Object " + object + " must be already added to enumerator!");
        }
        return res;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        TObjectIntIterator iter = this.myNumbers.iterator();
        while (iter.hasNext()) {
            iter.advance();
            buffer.append(iter.value()).append(": ").append(iter.key()).append("\n");
        }
        return buffer.toString();
    }
}

