/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentIntKeyRefValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

class ConcurrentIntKeySoftValueHashMap<V>
extends ConcurrentIntKeyRefValueHashMap<V> {
    ConcurrentIntKeySoftValueHashMap() {
    }

    @Override
    @NotNull
    protected ConcurrentIntKeyRefValueHashMap.IntReference<V> createReference(int key, @NotNull V value, @NotNull ReferenceQueue<V> queue) {
        return new MyRef(key, value, queue);
    }

    private static class MyRef<V>
    extends SoftReference<V>
    implements ConcurrentIntKeyRefValueHashMap.IntReference<V> {
        private final int valueHash;
        private final int key;

        private MyRef(int key, @NotNull V referent, @NotNull ReferenceQueue<V> queue) {
            super(referent, queue);
            this.key = key;
            this.valueHash = referent.hashCode();
        }

        public int hashCode() {
            return this.valueHash;
        }

        public boolean equals(Object obj) {
            Object v = this.get();
            if (!(obj instanceof MyRef)) {
                return false;
            }
            MyRef other = (MyRef)obj;
            return other.valueHash == this.valueHash && this.key == other.getKey() && Comparing.equal(v, other.get());
        }

        @Override
        public int getKey() {
            return this.key;
        }
    }
}

