/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;

public enum ThreeState {
    YES,
    NO,
    UNSURE;


    @NotNull
    public static ThreeState fromBoolean(boolean value) {
        return value ? YES : NO;
    }

    @NotNull
    public ThreeState merge(ThreeState other) {
        return this == other ? this : UNSURE;
    }

    public boolean toBoolean() {
        if (this == UNSURE) {
            throw new IllegalStateException("Must be or YES, or NO");
        }
        return this == YES;
    }

    @NotNull
    public static ThreeState mostPositive(@NotNull Iterable<ThreeState> states) {
        ThreeState result = NO;
        for (ThreeState state : states) {
            switch (state) {
                case YES: {
                    return YES;
                }
                case UNSURE: {
                    result = UNSURE;
                }
            }
        }
        return result;
    }

    @NotNull
    public static ThreeState merge(@NotNull Iterable<ThreeState> states) {
        ThreeState result = null;
        for (ThreeState state : states) {
            if (state == UNSURE) {
                return UNSURE;
            }
            if (result == null) {
                result = state;
                continue;
            }
            if (result == state) continue;
            return UNSURE;
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument should not be empty");
        }
        return result;
    }
}

