/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public enum LineSeparator {
    LF("\n"),
    CRLF("\r\n"),
    CR("\r");

    private final String mySeparatorString;
    private final byte[] myBytes;

    private LineSeparator(String separatorString) {
        this.mySeparatorString = separatorString;
        this.myBytes = separatorString.getBytes(StandardCharsets.UTF_8);
    }

    @NotNull
    public static LineSeparator fromString(@NotNull String string) {
        for (LineSeparator separator : LineSeparator.values()) {
            if (!separator.getSeparatorString().equals(string)) continue;
            return separator;
        }
        Logger.getInstance(LineSeparator.class).error("Invalid string for line separator: " + StringUtil.escapeStringCharacters(string));
        return LineSeparator.getSystemLineSeparator();
    }

    @NotNull
    public String getSeparatorString() {
        return this.mySeparatorString;
    }

    public byte @NotNull [] getSeparatorBytes() {
        return this.myBytes;
    }

    @NotNull
    public static LineSeparator getSystemLineSeparator() {
        return SystemInfo.isWindows ? CRLF : LF;
    }
}

