/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharsetToolkit {
    public static final String UTF8 = "UTF-8";
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final Charset UTF_16_CHARSET = StandardCharsets.UTF_16;
    public static final Charset UTF_16LE_CHARSET = StandardCharsets.UTF_16LE;
    public static final Charset UTF_16BE_CHARSET = StandardCharsets.UTF_16BE;
    public static final Charset UTF_32BE_CHARSET = Charset.forName("UTF-32BE");
    public static final Charset UTF_32LE_CHARSET = Charset.forName("UTF-32LE");
    public static final Charset US_ASCII_CHARSET = StandardCharsets.US_ASCII;
    public static final Charset ISO_8859_1_CHARSET = StandardCharsets.ISO_8859_1;
    public static final Charset WIN_1251_CHARSET = Charset.forName("windows-1251");
    private static final byte FF = -1;
    private static final byte FE = -2;
    private static final byte EF = -17;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final int BINARY_THRESHOLD = 9;
    private final byte[] buffer;
    @NotNull
    private final Charset defaultCharset;
    private boolean enforce8Bit;
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    public static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};
    public static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    public static final String FILE_ENCODING_PROPERTY = "file.encoding";
    private static final Map<Charset, byte[]> CHARSET_TO_MANDATORY_BOM = new THashMap(4);

    public CharsetToolkit(byte @NotNull [] buffer) {
        this.buffer = buffer;
        this.defaultCharset = CharsetToolkit.getDefaultSystemCharset();
    }

    public CharsetToolkit(byte @NotNull [] buffer, @NotNull Charset defaultCharset) {
        this.buffer = buffer;
        this.defaultCharset = defaultCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream) throws IOException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(4);
        boolean mustReset = true;
        try {
            int ret = stream.read();
            if (ret == -1) {
                InputStream inputStream = stream;
                return inputStream;
            }
            byte b0 = (byte)ret;
            if (b0 != -17 && b0 != -1 && b0 != -2 && b0 != 0) {
                InputStream inputStream = stream;
                return inputStream;
            }
            ret = stream.read();
            if (ret == -1) {
                InputStream inputStream = stream;
                return inputStream;
            }
            byte b1 = (byte)ret;
            if (b0 == -1 && b1 == -2) {
                stream.mark(2);
                ret = stream.read();
                if (ret == -1) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
                byte b2 = (byte)ret;
                if (b2 != 0) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
                ret = stream.read();
                if (ret == -1) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
                byte b3 = (byte)ret;
                if (b3 != 0) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
                mustReset = false;
                InputStream inputStream = stream;
                return inputStream;
            }
            if (b0 == -2 && b1 == -1) {
                mustReset = false;
                InputStream b2 = stream;
                return b2;
            }
            if (b0 == -17 && b1 == -69) {
                ret = stream.read();
                if (ret == -1) {
                    InputStream b2 = stream;
                    return b2;
                }
                byte b2 = (byte)ret;
                if (b2 == -65) {
                    mustReset = false;
                    InputStream b3 = stream;
                    return b3;
                }
                InputStream b3 = stream;
                return b3;
            }
            if (b0 == 0 && b1 == 0) {
                ret = stream.read();
                if (ret == -1) {
                    InputStream b2 = stream;
                    return b2;
                }
                byte b2 = (byte)ret;
                if (b2 != -2) {
                    InputStream b3 = stream;
                    return b3;
                }
                ret = stream.read();
                if (ret == -1) {
                    InputStream b3 = stream;
                    return b3;
                }
                byte b3 = (byte)ret;
                if (b3 != -1) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
                mustReset = false;
                InputStream inputStream = stream;
                return inputStream;
            }
            InputStream inputStream = stream;
            return inputStream;
        }
        finally {
            if (mustReset) {
                stream.reset();
            }
        }
    }

    public void setEnforce8Bit(boolean enforce) {
        this.enforce8Bit = enforce;
    }

    @NotNull
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Charset guessEncoding(int startOffset, int endOffset, @NotNull Charset defaultCharset) {
        Charset charset = this.guessFromBOM();
        if (charset != null) {
            return charset;
        }
        GuessedEncoding encoding = this.guessFromContent(startOffset, endOffset);
        switch (encoding) {
            case SEVEN_BIT: {
                return this.enforce8Bit ? defaultCharset : StandardCharsets.US_ASCII;
            }
            case INVALID_UTF8: {
                return defaultCharset;
            }
            case VALID_UTF8: {
                return StandardCharsets.UTF_8;
            }
        }
        return null;
    }

    @NotNull
    public static String bytesToString(byte @NotNull [] bytes, @NotNull Charset defaultCharset) {
        Charset charset = new CharsetToolkit(bytes, defaultCharset).guessEncoding(bytes.length);
        if (charset == null) {
            charset = defaultCharset;
        }
        return CharsetToolkit.decodeString(bytes, charset);
    }

    @NotNull
    public static String decodeString(byte @NotNull [] bytes, @NotNull Charset charset) {
        int bomLength = CharsetToolkit.getBOMLength(bytes, charset);
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
        return charBuffer.toString();
    }

    @Nullable
    public static String tryDecodeString(byte @NotNull [] bytes, @NotNull Charset charset) {
        try {
            int bomLength = CharsetToolkit.getBOMLength(bytes, charset);
            ByteBuffer buffer = ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength);
            CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    @NotNull
    public GuessedEncoding guessFromContent(int guess_length) {
        return this.guessFromContent(0, guess_length);
    }

    @NotNull
    public GuessedEncoding guessFromContent(int startOffset, int endOffset) {
        boolean highOrderBit = false;
        boolean validU8Char = true;
        boolean hasBinary = false;
        int end = Math.min(this.buffer.length, endOffset);
        for (int i = startOffset; i < end; ++i) {
            byte b5;
            byte b0 = this.buffer[i];
            byte b1 = i + 1 >= end ? (byte)0 : this.buffer[i + 1];
            byte b2 = i + 2 >= end ? (byte)0 : this.buffer[i + 2];
            byte b3 = i + 3 >= end ? (byte)0 : this.buffer[i + 3];
            byte b4 = i + 4 >= end ? (byte)0 : this.buffer[i + 4];
            byte by = b5 = i + 5 >= end ? (byte)0 : this.buffer[i + 5];
            if (b0 < 0) {
                highOrderBit = true;
                if (CharsetToolkit.isTwoBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1)) {
                        validU8Char = false;
                    } else {
                        ++i;
                    }
                } else if (CharsetToolkit.isThreeBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1) || !CharsetToolkit.isContinuationChar(b2)) {
                        validU8Char = false;
                    } else {
                        i += 2;
                    }
                } else if (CharsetToolkit.isFourBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3))) {
                        validU8Char = false;
                    } else {
                        i += 3;
                    }
                } else if (CharsetToolkit.isFiveBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4))) {
                        validU8Char = false;
                    } else {
                        i += 4;
                    }
                } else if (CharsetToolkit.isSixBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4) && CharsetToolkit.isContinuationChar(b5))) {
                        validU8Char = false;
                    } else {
                        i += 5;
                    }
                } else {
                    validU8Char = false;
                }
            } else if (b0 < 9) {
                hasBinary = true;
                break;
            }
            if (!validU8Char) break;
        }
        if (!highOrderBit && !hasBinary) {
            return GuessedEncoding.SEVEN_BIT;
        }
        if (!validU8Char) {
            return GuessedEncoding.INVALID_UTF8;
        }
        if (hasBinary) {
            return GuessedEncoding.BINARY;
        }
        return GuessedEncoding.VALID_UTF8;
    }

    @Nullable
    public Charset guessFromBOM() {
        return CharsetToolkit.guessFromBOM(this.buffer);
    }

    @Nullable
    public static Charset guessFromBOM(byte @NotNull [] buffer) {
        if (CharsetToolkit.hasUTF8Bom(buffer)) {
            return StandardCharsets.UTF_8;
        }
        if (CharsetToolkit.hasUTF32BEBom(buffer)) {
            return UTF_32BE_CHARSET;
        }
        if (CharsetToolkit.hasUTF32LEBom(buffer)) {
            return UTF_32LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16LEBom(buffer)) {
            return UTF_16LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16BEBom(buffer)) {
            return UTF_16BE_CHARSET;
        }
        return null;
    }

    public Charset guessEncoding(int guess_length) {
        return this.guessEncoding(0, guess_length, this.defaultCharset);
    }

    public static Charset guessEncoding(@NotNull File f, int bufferLength, @NotNull Charset defaultCharset) throws IOException {
        int read;
        byte[] buffer = new byte[bufferLength];
        try (FileInputStream fis = new FileInputStream(f);){
            read = fis.read(buffer);
        }
        CharsetToolkit toolkit = new CharsetToolkit(buffer, defaultCharset);
        return toolkit.guessEncoding(read);
    }

    private static boolean isContinuationChar(byte b) {
        return b <= -65;
    }

    private static boolean isTwoBytesSequence(byte b) {
        return -64 <= b && b <= -33;
    }

    private static boolean isThreeBytesSequence(byte b) {
        return -32 <= b && b <= -17;
    }

    private static boolean isFourBytesSequence(byte b) {
        return -16 <= b && b <= -9;
    }

    private static boolean isFiveBytesSequence(byte b) {
        return -8 <= b && b <= -5;
    }

    private static boolean isSixBytesSequence(byte b) {
        return -4 <= b && b <= -3;
    }

    @NotNull
    public static Charset getDefaultSystemCharset() {
        return Charset.defaultCharset();
    }

    @NotNull
    public static Charset getPlatformCharset() {
        String name = System.getProperty("sun.jnu.encoding");
        return ObjectUtils.notNull(CharsetToolkit.forName(name), CharsetToolkit.getDefaultSystemCharset());
    }

    public static boolean hasUTF8Bom(byte @NotNull [] bom) {
        return ArrayUtil.startsWith(bom, UTF8_BOM);
    }

    public static boolean hasUTF16LEBom(byte @NotNull [] bom) {
        return ArrayUtil.startsWith(bom, UTF16LE_BOM);
    }

    public static boolean hasUTF16BEBom(byte @NotNull [] bom) {
        return ArrayUtil.startsWith(bom, UTF16BE_BOM);
    }

    public static boolean hasUTF32BEBom(byte @NotNull [] bom) {
        return ArrayUtil.startsWith(bom, UTF32BE_BOM);
    }

    public static boolean hasUTF32LEBom(byte @NotNull [] bom) {
        return ArrayUtil.startsWith(bom, UTF32LE_BOM);
    }

    public static Charset @NotNull [] getAvailableCharsets() {
        Collection<Charset> collection = Charset.availableCharsets().values();
        return collection.toArray(new Charset[0]);
    }

    public static byte @NotNull [] getUtf8Bytes(@NotNull String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static int getBOMLength(byte @NotNull [] content, @NotNull Charset charset) {
        if (charset.name().contains(UTF8) && CharsetToolkit.hasUTF8Bom(content)) {
            return UTF8_BOM.length;
        }
        if (CharsetToolkit.hasUTF32BEBom(content)) {
            return UTF32BE_BOM.length;
        }
        if (CharsetToolkit.hasUTF32LEBom(content)) {
            return UTF32LE_BOM.length;
        }
        if (CharsetToolkit.hasUTF16LEBom(content)) {
            return UTF16LE_BOM.length;
        }
        if (CharsetToolkit.hasUTF16BEBom(content)) {
            return UTF16BE_BOM.length;
        }
        return 0;
    }

    public static byte @Nullable [] getMandatoryBom(@NotNull Charset charset) {
        return CHARSET_TO_MANDATORY_BOM.get(charset);
    }

    public static byte @Nullable [] getPossibleBom(@NotNull Charset charset) {
        if (charset.equals(StandardCharsets.UTF_8)) {
            return UTF8_BOM;
        }
        return CHARSET_TO_MANDATORY_BOM.get(charset);
    }

    public static boolean canHaveBom(@NotNull Charset charset, byte @NotNull [] bom) {
        return charset.equals(StandardCharsets.UTF_8) && Arrays.equals(bom, UTF8_BOM) || Arrays.equals(CharsetToolkit.getMandatoryBom(charset), bom);
    }

    @Nullable
    public static Charset forName(@Nullable String name) {
        Charset charset = null;
        if (name != null) {
            try {
                charset = Charset.forName(name);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
        }
        return charset;
    }

    static {
        CHARSET_TO_MANDATORY_BOM.put(UTF_16LE_CHARSET, UTF16LE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_16BE_CHARSET, UTF16BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32BE_CHARSET, UTF32BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32LE_CHARSET, UTF32LE_BOM);
    }

    public static enum GuessedEncoding {
        SEVEN_BIT,
        VALID_UTF8,
        INVALID_UTF8,
        BINARY;

    }
}

