/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JarUtil {
    private static final Logger LOG = Logger.getInstance(JarUtil.class);

    public static boolean containsClass(@NotNull String jarPath, @NotNull String className) {
        return JarUtil.containsClass(new File(jarPath), className);
    }

    public static boolean containsClass(@NotNull File file, String className) {
        String entryPath = className.replace('.', '/') + ".class";
        return JarUtil.containsEntry(file, entryPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsEntry(File file, String entryPath) {
        if (!file.canRead()) return false;
        try (JarFile jarFile = new JarFile(file);){
            boolean bl = jarFile.getEntry(entryPath) != null;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    public static String getJarAttribute(@NotNull File file, @NotNull Attributes.Name attribute) {
        return JarUtil.getJarAttributeImpl(file, null, attribute);
    }

    @Nullable
    public static String getJarAttribute(@NotNull File file, @NotNull String entryName, @NotNull Attributes.Name attribute) {
        return JarUtil.getJarAttributeImpl(file, entryName, attribute);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJarAttributeImpl(@NotNull File file, @Nullable String entryName, @NotNull Attributes.Name attribute) {
        if (!file.canRead()) return null;
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return null;
            Attributes attributes = entryName != null ? manifest.getAttributes(entryName) : manifest.getMainAttributes();
            String string = attributes.getValue(attribute);
            return string;
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Properties loadProperties(@NotNull File file, @NotNull String entryName) {
        if (!file.canRead()) return null;
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) return null;
            Properties properties2 = new Properties();
            properties2.load(zipFile.getInputStream(entry));
            Properties properties = properties2;
            return properties;
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }
}

