/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullLazyValue;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public abstract class LazyInstance<T>
extends NotNullLazyValue<T> {
    protected abstract Class<T> getInstanceClass() throws ClassNotFoundException;

    @Override
    @NotNull
    protected final T compute() {
        try {
            Class<T> tClass = this.getInstanceClass();
            Constructor<T> constructor = tClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return tClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

