/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Conditions {
    @Deprecated
    public static final Condition<Object> TRUE = Conditions.alwaysTrue();

    private Conditions() {
    }

    @NotNull
    public static <T> Condition<T> alwaysTrue() {
        return Condition.TRUE;
    }

    @NotNull
    public static <T> Condition<T> alwaysFalse() {
        return Condition.FALSE;
    }

    @NotNull
    public static <T> Condition<T> notNull() {
        return Condition.NOT_NULL;
    }

    @NotNull
    public static <T> Condition<T> constant(boolean value) {
        return value ? Conditions.alwaysTrue() : Conditions.alwaysFalse();
    }

    @NotNull
    public static <T> Condition<T> instanceOf(final @NotNull Class<?> clazz) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        };
    }

    @NotNull
    public static <T> Condition<T> notInstanceOf(final @NotNull Class<?> clazz) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return !clazz.isInstance(t);
            }
        };
    }

    @NotNull
    public static Condition<Class<?>> assignableTo(final @NotNull Class<?> clazz) {
        return new Condition<Class<?>>(){

            @Override
            public boolean value(Class<?> t) {
                return clazz.isAssignableFrom(t);
            }
        };
    }

    @NotNull
    public static <T> Condition<T> instanceOf(final Class<?> ... clazz) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                for (Class aClass : clazz) {
                    if (!aClass.isInstance(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @NotNull
    public static <T> Condition<T> is(T option) {
        return Conditions.equalTo(option);
    }

    @NotNull
    public static <T> Condition<T> equalTo(final Object option) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return Comparing.equal(t, option);
            }
        };
    }

    @NotNull
    public static <T> Condition<T> notEqualTo(final Object option) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return !Comparing.equal(t, option);
            }
        };
    }

    @NotNull
    public static <T> Condition<T> oneOf(T ... options) {
        return Conditions.oneOf(Arrays.asList(options));
    }

    @NotNull
    public static <T> Condition<T> oneOf(final @NotNull Collection<? extends T> options) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return options.contains(t);
            }
        };
    }

    @NotNull
    public static <T> Condition<T> not(@NotNull Condition<? super T> c) {
        if (c == Conditions.alwaysTrue()) {
            return Conditions.alwaysFalse();
        }
        if (c == Conditions.alwaysFalse()) {
            return Conditions.alwaysTrue();
        }
        if (c instanceof Not) {
            return ((Not)c).c;
        }
        return new Not<T>(c);
    }

    @NotNull
    public static <T> Condition<T> and(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        return Conditions.and2(c1, c2);
    }

    @NotNull
    public static <T> Condition<T> and2(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        if (c1 == Conditions.alwaysTrue() || c2 == Conditions.alwaysFalse()) {
            return c2;
        }
        if (c2 == Conditions.alwaysTrue() || c1 == Conditions.alwaysFalse()) {
            return c1;
        }
        return new And<T>(c1, c2);
    }

    @NotNull
    public static <T> Condition<T> or(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        return Conditions.or2(c1, c2);
    }

    @NotNull
    public static <T> Condition<T> or2(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        if (c1 == Conditions.alwaysFalse() || c2 == Conditions.alwaysTrue()) {
            return c2;
        }
        if (c2 == Conditions.alwaysFalse() || c1 == Conditions.alwaysTrue()) {
            return c1;
        }
        return new Or<T>(c1, c2);
    }

    @NotNull
    public static <A, B> Condition<A> compose(final @NotNull Function<? super A, B> fun, final @NotNull Condition<? super B> condition) {
        return new Condition<A>(){

            @Override
            public boolean value(A o) {
                return condition.value(fun.fun(o));
            }
        };
    }

    @NotNull
    public static <T> Condition<T> cached(@NotNull Condition<? super T> c) {
        return new SoftRefCache<T>(c);
    }

    private static class SoftRefCache<T>
    implements Condition<T> {
        private final Map<Integer, Pair<SoftReference<T>, Boolean>> myCache = new HashMap<Integer, Pair<SoftReference<T>, Boolean>>();
        private final Condition<? super T> myCondition;

        SoftRefCache(@NotNull Condition<? super T> condition) {
            this.myCondition = condition;
        }

        @Override
        public final boolean value(T object) {
            int key = object.hashCode();
            Pair<SoftReference<T>, Boolean> entry = this.myCache.get(key);
            if (entry == null || ((SoftReference)entry.first).get() != object) {
                boolean value = this.myCondition.value(object);
                this.myCache.put(key, Pair.create(new SoftReference<T>(object), value));
                return value;
            }
            return (Boolean)entry.second;
        }
    }

    private static class Or<T>
    implements Condition<T> {
        final Condition<? super T> c1;
        final Condition<? super T> c2;

        Or(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public boolean value(T object) {
            return this.c1.value(object) || this.c2.value(object);
        }
    }

    private static class And<T>
    implements Condition<T> {
        final Condition<? super T> c1;
        final Condition<? super T> c2;

        And(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public boolean value(T object) {
            return this.c1.value(object) && this.c2.value(object);
        }
    }

    private static class Not<T>
    implements Condition<T> {
        final Condition<? super T> c;

        Not(@NotNull Condition<? super T> c) {
            this.c = c;
        }

        @Override
        public boolean value(T value) {
            return !this.c.value(value);
        }
    }
}

