/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

public interface DiffPolicy {
    public static final DiffPolicy LINES_WO_FORMATTING = new LineBlocks(ComparisonPolicy.IGNORE_SPACE);
    public static final DiffPolicy DEFAULT_LINES = new LineBlocks(ComparisonPolicy.DEFAULT);

    public DiffFragment @NotNull [] buildFragments(@NotNull DiffString var1, @NotNull DiffString var2) throws FilesTooBigForDiffException;

    public DiffFragment @NotNull [] buildFragments(@NotNull String var1, @NotNull String var2) throws FilesTooBigForDiffException;

    public static class ByChar
    implements DiffPolicy {
        private final ComparisonPolicy myComparisonPolicy;

        public ByChar(ComparisonPolicy comparisonPolicy) {
            this.myComparisonPolicy = comparisonPolicy;
        }

        @Override
        public DiffFragment @NotNull [] buildFragments(@NotNull String text1, @NotNull String text2) throws FilesTooBigForDiffException {
            return this.buildFragments(DiffString.create(text1), DiffString.create(text2));
        }

        @Override
        public DiffFragment @NotNull [] buildFragments(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
            return this.myComparisonPolicy.buildFragments(ByChar.splitByChar(text1), ByChar.splitByChar(text2));
        }

        private static DiffString[] splitByChar(@NotNull DiffString text) {
            DiffString[] result = new DiffString[text.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = text.substring(i, i + 1);
            }
            return result;
        }
    }

    public static class LineBlocks
    implements DiffPolicy {
        private final ComparisonPolicy myComparisonPolicy;

        public LineBlocks(ComparisonPolicy comparisonPolicy) {
            this.myComparisonPolicy = comparisonPolicy;
        }

        @Override
        public DiffFragment @NotNull [] buildFragments(@NotNull String text1, @NotNull String text2) throws FilesTooBigForDiffException {
            return this.buildFragments(DiffString.create(text1), DiffString.create(text2));
        }

        @Override
        public DiffFragment @NotNull [] buildFragments(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
            DiffString[] strings1 = text1.tokenize();
            DiffString[] strings2 = text2.tokenize();
            return this.myComparisonPolicy.buildDiffFragmentsFromLines(strings1, strings2);
        }
    }
}

