/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PropertiesUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.FList;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jna.TypeMapper;
import com.sun.jna.platform.FileUtils;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jpountz.lz4.LZ4Factory;
import org.apache.log4j.Appender;
import org.apache.oro.text.regex.PatternMatcher;
import org.intellij.lang.annotations.Flow;
import org.jdom.Document;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_LOG_CONFIG_FILE = "idea.log.config.file";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String OPTIONS_DIRECTORY = "options";
    public static final String DEFAULT_EXT = ".xml";
    public static final String DEFAULT_OPTIONS_FILE = "other.xml";
    private static final String KOTLIN_IDE_IML_RELATIVE_PATH = "kotlin/idea/kotlin.idea.iml";
    private static final String INTELLIJ_SUB_REPO_NAME = "intellij";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String PROPERTY_VENDOR_NAME = "idea.vendor.name";
    private static final String LIB_DIRECTORY = "lib";
    private static final String PLUGINS_DIRECTORY = "plugins";
    private static final String BIN_DIRECTORY = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_DIRECTORY = "config";
    private static final String SYSTEM_DIRECTORY = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static Path ourCommonDataPath;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginsPath;
    private static String ourLogPath;

    @NotNull
    public static String getHomePath() {
        return PathManager.getHomePath(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result = ourHomePath;
        if (result != null) {
            return result;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result = ourHomePath;
            if (result != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            String explicit = PathManager.getExplicitPath(PROPERTY_HOME_PATH);
            if (explicit == null) {
                explicit = PathManager.getExplicitPath(PROPERTY_HOME);
            }
            if (explicit != null) {
                result = explicit;
                if (!Files.isDirectory(Paths.get(result, new String[0]), new LinkOption[0])) {
                    ourHomePath = result;
                    throw new RuntimeException("Invalid home path '" + result + "'");
                }
            } else if (insideIde && (result = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result != null && SystemInfoRt.isWindows) {
                try {
                    result = Paths.get(result, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ourBinDirectories = result == null ? Collections.emptyList() : PathManager.getBinDirectories(Paths.get(result, new String[0]));
            ourHomePath = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    private static List<Path> getBinDirectories() {
        List<Path> result = ourBinDirectories;
        if (result == null) {
            PathManager.getHomePath(true);
            result = ourBinDirectories;
        }
        return result;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        Path home = Paths.get(PathManager.getHomePath(), new String[0]);
        Path target = Paths.get(path, new String[0]);
        try {
            home = home.toRealPath(new LinkOption[0]);
            target = target.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return target.startsWith(home);
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        String rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class");
        if (rootPath == null) {
            return null;
        }
        Path root = Paths.get(rootPath, new String[0]).toAbsolutePath();
        if (SystemInfoRt.isWindows && System.getProperties().containsKey("TEST_WORKSPACE")) {
            try {
                root = root.toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        while ((root = root.getParent()) != null && !PathManager.isIdeaHome(root) && !PathManager.isKotlinIdeRepoHome(root)) {
        }
        if (root != null && PathManager.isKotlinIdeRepoHome(root)) {
            root = root.resolve(INTELLIJ_SUB_REPO_NAME);
        }
        return root != null ? root.toString() : null;
    }

    private static boolean isKotlinIdeRepoHome(@NotNull Path path) {
        return Files.isDirectory(path, new LinkOption[0]) && Files.isRegularFile(path.resolve(KOTLIN_IDE_IML_RELATIVE_PATH), new LinkOption[0]) && Files.isDirectory(path.resolve(INTELLIJ_SUB_REPO_NAME), new LinkOption[0]) && PathManager.isIdeaHome(path.resolve(INTELLIJ_SUB_REPO_NAME));
    }

    private static boolean isIdeaHome(Path root) {
        for (Path binDir : PathManager.getBinDirectories(root)) {
            if (!Files.isRegularFile(binDir.resolve(PROPERTIES_FILE_NAME), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static List<Path> getBinDirectories(Path root) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        String[] subDirs = new String[]{BIN_DIRECTORY, "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            Path dir = root.resolve(subDir);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            dir = dir.resolve(osSuffix);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        return PathManager.getHomePath() + '/' + BIN_DIRECTORY;
    }

    @Nullable
    public static Path findBinFile(@NotNull String fileName) {
        for (Path binDir : PathManager.getBinDirectories()) {
            Path candidate = binDir.resolve(fileName);
            if (!Files.isRegularFile(candidate, new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static Path findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        Path file = PathManager.findBinFile(fileName);
        if (file != null) {
            return file;
        }
        StringBuilder message = new StringBuilder();
        message.append('\'').append(fileName).append("' not found in directories:");
        for (Path directory : PathManager.getBinDirectories()) {
            message.append('\n').append(directory);
        }
        throw new FileNotFoundException(message.toString());
    }

    @NotNull
    public static String getLibPath() {
        return PathManager.getHomePath() + '/' + LIB_DIRECTORY;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        return PathManager.getHomePath() + '/' + PLUGINS_DIRECTORY;
    }

    @NotNull
    public static synchronized Path getCommonDataPath() {
        if (ourCommonDataPath == null) {
            Path path = Paths.get(PathManager.platformPath("", "Application Support", "", "APPDATA", "", "XDG_DATA_HOME", ".local/share", ""), new String[0]);
            if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ourCommonDataPath = path;
        }
        return ourCommonDataPath;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static Path getConfigDir() {
        return Paths.get(PathManager.getConfigPath(), new String[0]);
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            return ourConfigPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_CONFIG_PATH);
        ourConfigPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + CONFIG_DIRECTORY);
        return ourConfigPath;
    }

    @NotNull
    public static String getScratchPath() {
        if (ourScratchPath != null) {
            return ourScratchPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SCRATCH_PATH);
        ourScratchPath = explicit != null ? explicit : PathManager.getConfigPath();
        return ourScratchPath;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        return PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
    }

    @NotNull
    public static String getOptionsPath() {
        return PathManager.getConfigPath() + '/' + OPTIONS_DIRECTORY;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        return Paths.get(PathManager.getOptionsPath(), fileName + DEFAULT_EXT).toFile();
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            return ourPluginsPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_PLUGINS_PATH);
        ourPluginsPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_CONFIG_PATH) == null ? PathManager.getDefaultPluginPathFor(PATHS_SELECTOR) : PathManager.getConfigPath() + '/' + PLUGINS_DIRECTORY);
        return ourPluginsPath;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        return PathManager.platformPath(selector, "Application Support", PLUGINS_DIRECTORY, "APPDATA", PLUGINS_DIRECTORY, "XDG_DATA_HOME", ".local/share", "");
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : null;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            return ourSystemPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SYSTEM_PATH);
        ourSystemPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + SYSTEM_DIRECTORY);
        return ourSystemPath;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        return PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
    }

    @NotNull
    public static String getTempPath() {
        return PathManager.getSystemPath() + "/tmp";
    }

    @NotNull
    public static File getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        return Paths.get(indexRootPath, new String[0]).toFile();
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            return ourLogPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_LOG_PATH);
        ourLogPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_SYSTEM_PATH) == null ? PathManager.platformPath(PATHS_SELECTOR, "Logs", "", "LOCALAPPDATA", LOG_DIRECTORY, "XDG_CACHE_HOME", ".cache", LOG_DIRECTORY) : PathManager.getSystemPath() + '/' + LOG_DIRECTORY);
        return ourLogPath;
    }

    @NotNull
    public static String getPluginTempPath() {
        return PathManager.getSystemPath() + '/' + PLUGINS_DIRECTORY;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader cl, @NotNull String resourcePath) {
        URL url = cl.getResource(resourcePath);
        return url != null ? PathManager.extractRoot(url, resourcePath) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.length() == 0 || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.first != null) {
                resultPath = (String)paths.first;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    public static void loadProperties() {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(System.getProperty(PROPERTIES_FILE));
        paths.add(PathManager.getCustomPropertiesFile());
        paths.add(SystemProperties.getUserHome() + '/' + PROPERTIES_FILE_NAME);
        for (Path binDir : PathManager.getBinDirectories()) {
            paths.add(binDir.resolve(PROPERTIES_FILE_NAME).toString());
        }
        Properties sysProperties = System.getProperties();
        for (String path : paths) {
            Path file = path != null ? Paths.get(path, new String[0]) : null;
            if (file == null || !Files.exists(file, new LinkOption[0])) continue;
            try {
                BufferedReader reader = Files.newBufferedReader(file);
                Throwable throwable = null;
                try {
                    Map<String, String> properties = PropertiesUtil.loadProperties(reader);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        String key = entry.getKey();
                        if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                            PathManager.log(path + ": '" + key + "' cannot be redefined");
                            continue;
                        }
                        if (sysProperties.containsKey(key)) continue;
                        sysProperties.setProperty(key, PathManager.substituteVars(entry.getValue()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                PathManager.log("Can't read property file '" + path + "': " + e.getMessage());
            }
        }
    }

    private static String getCustomPropertiesFile() {
        String configPath = PathManager.getCustomOptionsDirectory();
        return configPath != null ? configPath + '/' + PROPERTIES_FILE_NAME : null;
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        return PathManager.substituteVars(s, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, @NotNull String ideaHomePath) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + '/' + BIN_DIRECTORY + '/' + s;
        }
        Matcher m = Lazy.PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                switch (key) {
                    case "idea.home.path": 
                    case "idea.home": {
                        value = ideaHomePath;
                        break;
                    }
                    case "idea.config.path": {
                        value = PathManager.getConfigPath();
                        break;
                    }
                    case "idea.system.path": {
                        value = PathManager.getSystemPath();
                    }
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = s.replace(m.group(), value);
            m = Lazy.PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        Path file = Paths.get(PathManager.getLibPath(), relativePath);
        if (!Files.exists(file, new LinkOption[0])) {
            file = Paths.get(PathManager.getHomePath(), "community/lib/" + relativePath);
        }
        return file.toFile();
    }

    @NotNull
    public static String getCommunityHomePath() {
        String path = PathManager.getHomePath();
        if (Files.isDirectory(Paths.get(path, "community/.idea"), new LinkOption[0])) {
            return path + "/community";
        }
        if (Files.isDirectory(Paths.get(path, "ultimate/community/.idea"), new LinkOption[0])) {
            return path + "/ultimate/community";
        }
        return path;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        String resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class");
        return resourceRoot != null ? Paths.get(resourceRoot, new String[0]).toAbsolutePath().toString() : null;
    }

    @NotNull
    public static Collection<String> getUtilClassPath() {
        Class[] classes;
        HashSet<String> classPath = new HashSet<String>();
        for (Class aClass : classes = new Class[]{PathManager.class, Strings.class, FList.class, MinusculeMatcher.class, StartUpMeasurer.class, SystemInfoRt.class, UrlClassLoader.class, Flow.class, Document.class, Appender.class, THashSet.class, Object2IntMap.class, TypeMapper.class, FileUtils.class, PatternMatcher.class, LZ4Factory.class}) {
            String path = PathManager.getJarPathForClass(aClass);
            if (path == null) continue;
            classPath.add(path);
        }
        String resourceRoot = PathManager.getResourceRoot(PathManager.class, "/messages/CommonBundle.properties");
        if (resourceRoot != null) {
            classPath.add(Paths.get(resourceRoot, new String[0]).toAbsolutePath().toString());
        }
        return classPath;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        return Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
    }

    @Nullable
    private static String getExplicitPath(String property) {
        String path = System.getProperty(property);
        return path != null ? PathManager.getAbsolutePath(StringUtilRt.unquoteString(path, '\"')) : null;
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = SystemProperties.getUserHome();
        String vendorName = PathManager.vendorName();
        if (SystemInfoRt.isMac) {
            String dir = userHome + "/Library/" + macDir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '/' + selector;
            }
            if (!macSub.isEmpty()) {
                dir = dir + '/' + macSub;
            }
            return dir;
        }
        if (SystemInfoRt.isWindows) {
            String dir = System.getenv(winVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir = dir + '\\' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '\\' + selector;
            }
            if (!winSub.isEmpty()) {
                dir = dir + '\\' + winSub;
            }
            return dir;
        }
        if (SystemInfoRt.isUnix) {
            String dir = System.getenv(xdgVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + '/' + xdgDfl;
            }
            dir = dir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '/' + selector;
            }
            if (!xdgSub.isEmpty()) {
                dir = dir + '/' + xdgSub;
            }
            return dir;
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static String vendorName() {
        String property = System.getProperty(PROPERTY_VENDOR_NAME);
        if (property == null) {
            try {
                Class<?> ex = Class.forName("com.intellij.openapi.application.ex.ApplicationInfoEx");
                Class<?> impl = Class.forName("com.intellij.openapi.application.impl.ApplicationInfoImpl");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Object instance = lookup.findStatic(impl, "getShadowInstance", MethodType.methodType(ex)).invoke();
                property = lookup.findVirtual(impl, "getShortCompanyName", MethodType.methodType(String.class)).invoke(instance);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.setProperty(PROPERTY_VENDOR_NAME, property != null ? property : "JetBrains");
        }
        return property;
    }

    private static class Lazy {
        private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");

        private Lazy() {
        }
    }
}

