/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.util.concurrency.CountingThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class ProcessIOExecutorService
extends ThreadPoolExecutor {
    public static final String POOLED_THREAD_PREFIX = "I/O pool ";
    public static final ExecutorService INSTANCE = new ProcessIOExecutorService();

    private ProcessIOExecutorService() {
        super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new MyCountingThreadFactory());
    }

    public int getThreadCounter() {
        return ((CountingThreadFactory)this.getThreadFactory()).getCount();
    }

    private static final class MyCountingThreadFactory
    extends CountingThreadFactory {
        private final ThreadFactory myThreadFactory = Executors.privilegedThreadFactory();

        private MyCountingThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = this.myThreadFactory.newThread(r);
            thread.setName(ProcessIOExecutorService.POOLED_THREAD_PREFIX + this.counter.incrementAndGet());
            thread.setPriority(4);
            return thread;
        }
    }
}

