/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class VcsLogBranchFilterImpl
implements VcsLogBranchFilter {
    @NotNull
    private final List<String> myBranches;
    @NotNull
    private final List<Pattern> myPatterns;
    @NotNull
    private final List<String> myExcludedBranches;
    @NotNull
    private final List<Pattern> myExcludedPatterns;

    VcsLogBranchFilterImpl(@NotNull List<String> branches, @NotNull List<Pattern> patterns, @NotNull List<String> excludedBranches, @NotNull List<Pattern> excludedPatterns) {
        this.myBranches = branches;
        this.myPatterns = patterns;
        this.myExcludedBranches = excludedBranches;
        this.myExcludedPatterns = excludedPatterns;
    }

    @NotNull
    public Collection<String> getTextPresentation() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.addAll(this.myBranches);
        result2.addAll(ContainerUtil.map(this.myPatterns, pattern -> pattern.pattern()));
        result2.addAll(ContainerUtil.map(this.myExcludedBranches, branchName -> "-" + branchName));
        result2.addAll(ContainerUtil.map(this.myExcludedPatterns, pattern -> "-" + pattern.pattern()));
        return result2;
    }

    public boolean isEmpty() {
        return this.myBranches.isEmpty() && this.myPatterns.isEmpty() && this.myExcludedBranches.isEmpty() && this.myExcludedPatterns.isEmpty();
    }

    @NonNls
    public String toString() {
        String result2 = "";
        if (!this.myPatterns.isEmpty()) {
            result2 = result2 + "on patterns: " + StringUtil.join(this.myPatterns, (String)", ");
        }
        if (!this.myBranches.isEmpty()) {
            if (!result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "on branches: " + StringUtil.join(this.myBranches, (String)", ");
        }
        if (!this.myExcludedPatterns.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on patterns: " + StringUtil.join(this.myExcludedPatterns, (String)", ");
        }
        if (!this.myExcludedBranches.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on branches: " + StringUtil.join(this.myExcludedBranches, (String)", ");
        }
        return result2;
    }

    public boolean matches(@NotNull String name) {
        return this.isIncluded(name) && !this.isExcluded(name);
    }

    private boolean isIncluded(@NotNull String name) {
        if (this.myPatterns.isEmpty() && this.myBranches.isEmpty()) {
            return true;
        }
        return VcsLogBranchFilterImpl.isMatched(name, this.myBranches, this.myPatterns);
    }

    private boolean isExcluded(@NotNull String name) {
        return VcsLogBranchFilterImpl.isMatched(name, this.myExcludedBranches, this.myExcludedPatterns);
    }

    private static boolean isMatched(@NotNull String name, @NotNull List<String> branches, @NotNull List<Pattern> patterns) {
        if (branches.contains(name)) {
            return true;
        }
        for (Pattern regexp : patterns) {
            if (!regexp.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsLogBranchFilterImpl filter = (VcsLogBranchFilterImpl)o;
        return Comparing.haveEqualElements(this.myBranches, filter.myBranches) && Comparing.haveEqualElements(this.myPatterns, filter.myPatterns) && Comparing.haveEqualElements(this.myExcludedBranches, filter.myExcludedBranches) && Comparing.haveEqualElements(this.myExcludedPatterns, filter.myExcludedPatterns);
    }

    public int hashCode() {
        return Objects.hash(Comparing.unorderedHashcode(this.myBranches), Comparing.unorderedHashcode(this.myPatterns), Comparing.unorderedHashcode(this.myExcludedBranches), Comparing.unorderedHashcode(this.myExcludedPatterns));
    }
}

