/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.exception.FrequentErrorLogger;
import com.intellij.util.text.JBDateFormat;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableModel
extends AbstractTableModel {
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    public static final int COMMIT_NOT_FOUND = -1;
    public static final int COMMIT_DOES_NOT_MATCH = -2;
    private static final Logger LOG = Logger.getInstance(GraphTableModel.class);
    private static final FrequentErrorLogger ERROR_LOG = FrequentErrorLogger.newInstance((Logger)LOG);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final Consumer<? super Runnable> myRequestMore;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private VisiblePack myDataPack = VisiblePack.EMPTY;
    private boolean myMoreRequested;

    public GraphTableModel(@NotNull VcsLogData logData, @NotNull Consumer<? super Runnable> requestMore, @NotNull VcsLogUiProperties properties) {
        this.myLogData = logData;
        this.myRequestMore = requestMore;
        this.myProperties = properties;
    }

    @Override
    public int getRowCount() {
        return this.myDataPack.getVisibleGraph().getVisibleCommitCount();
    }

    @Override
    public final int getColumnCount() {
        return VcsLogColumn.count();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return VcsLogColumn.fromOrdinal(column).getContentClass();
    }

    @Override
    public String getColumnName(int column) {
        return VcsLogColumn.fromOrdinal(column).getName();
    }

    public int getRowOfCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (!this.myLogData.getStorage().containsCommit(new CommitId(hash, root))) {
            return -1;
        }
        return this.getRowOfCommitWithoutCheck(hash, root);
    }

    public int getRowOfCommitByPartOfHash(@NotNull String partialHash) {
        CommitIdByStringCondition hashByString = new CommitIdByStringCondition(partialHash);
        Ref commitExists = new Ref((Object)false);
        CommitId commitId = this.myLogData.getStorage().findCommitId((Condition<? super CommitId>)((Condition)commitId1 -> {
            if (hashByString.value((CommitId)commitId1)) {
                commitExists.set((Object)true);
                return this.getRowOfCommitWithoutCheck(commitId1.getHash(), commitId1.getRoot()) >= 0;
            }
            return false;
        }));
        return commitId != null ? this.getRowOfCommitWithoutCheck(commitId.getHash(), commitId.getRoot()) : ((Boolean)commitExists.get() != false ? -2 : -1);
    }

    private int getRowOfCommitWithoutCheck(@NotNull Hash hash, @NotNull VirtualFile root) {
        int commitIndex = this.myLogData.getCommitIndex(hash, root);
        Integer rowIndex = this.myDataPack.getVisibleGraph().getVisibleRowIndex((Object)commitIndex);
        return rowIndex == null ? -2 : rowIndex;
    }

    @Override
    @NotNull
    public final Object getValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, VcsLogColumn.fromOrdinal(columnIndex));
    }

    @NotNull
    public final Object getValueAt(int rowIndex, @NotNull VcsLogColumn column) {
        if (rowIndex >= this.getRowCount() - 1 && this.canRequestMore()) {
            this.requestToLoadMore(EmptyRunnable.INSTANCE);
        }
        try {
            return this.getValue(rowIndex, column, (VcsShortCommitDetails)this.getCommitMetadata(rowIndex));
        }
        catch (ProcessCanceledException ignore) {
            return this.getStub(column);
        }
        catch (Throwable t) {
            ERROR_LOG.error("Failed to get information for the log table", t);
            return this.getStub(column);
        }
    }

    @NotNull
    private Object getValue(int rowIndex, @NotNull VcsLogColumn column, @NotNull VcsShortCommitDetails data) {
        switch (column) {
            case ROOT: {
                return this.myDataPack.getFilePath(rowIndex);
            }
            case COMMIT: {
                return new GraphCommitCell(data.getSubject(), this.getRefsAtRow(rowIndex), this.myDataPack.getVisibleGraph().getRowInfo(rowIndex).getPrintElements());
            }
            case AUTHOR: {
                return CommitPresentationUtil.getAuthorPresentation(data);
            }
            case DATE: {
                long timeStamp = this.myProperties.exists(CommonUiProperties.PREFER_COMMIT_DATE) && Boolean.TRUE.equals(this.myProperties.get(CommonUiProperties.PREFER_COMMIT_DATE)) ? data.getCommitTime() : data.getAuthorTime();
                return timeStamp < 0L ? "" : JBDateFormat.getFormatter().formatPrettyDateTime(timeStamp);
            }
            case HASH: {
                return ((Hash)data.getId()).toShortString();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)column));
    }

    @NotNull
    private Object getStub(@NotNull VcsLogColumn column) {
        switch (column) {
            case ROOT: {
                return VcsUtil.getFilePath((VirtualFile)((VirtualFile)ContainerUtil.getFirstItem(this.myLogData.getRoots())));
            }
            case COMMIT: {
                return new GraphCommitCell("", Collections.emptyList(), Collections.emptyList());
            }
        }
        return "";
    }

    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        this.myMoreRequested = true;
        this.myRequestMore.consume((Object)onLoaded);
    }

    public boolean canRequestMore() {
        return !this.myMoreRequested && this.myDataPack.canRequestMore();
    }

    void setVisiblePack(@NotNull VisiblePack visiblePack) {
        this.myDataPack = visiblePack;
        this.myMoreRequested = false;
        this.fireTableDataChanged();
    }

    @NotNull
    public VisiblePack getVisiblePack() {
        return this.myDataPack;
    }

    @NotNull
    public Integer getIdAtRow(int row2) {
        return (Integer)this.myDataPack.getVisibleGraph().getRowInfo(row2).getCommit();
    }

    @NotNull
    public VirtualFile getRootAtRow(int row2) {
        return this.myDataPack.getRoot(row2);
    }

    @NotNull
    public List<VcsRef> getRefsAtRow(int row2) {
        return ((RefsModel)this.myDataPack.getRefs()).refsToCommit(this.getIdAtRow(row2));
    }

    @NotNull
    public List<VcsRef> getBranchesAtRow(int row2) {
        return ContainerUtil.filter(this.getRefsAtRow(row2), ref -> ref.getType().isBranch());
    }

    @NotNull
    public VcsFullCommitDetails getFullDetails(int row2) {
        Integer id = this.getIdAtRow(row2);
        return (VcsFullCommitDetails)this.myLogData.getCommitDetailsGetter().getCommitData(id, Collections.singleton(id));
    }

    @NotNull
    public VcsCommitMetadata getCommitMetadata(int row2) {
        return (VcsCommitMetadata)this.myLogData.getMiniDetailsGetter().getCommitData(this.getIdAtRow(row2), this.getCommitsToPreload(row2));
    }

    @Nullable
    public CommitId getCommitId(int row2) {
        return this.myLogData.getCommitId(this.getIdAtRow(row2));
    }

    @NotNull
    public List<VcsFullCommitDetails> getFullDetails(int[] rows) {
        return GraphTableModel.getDataForRows(rows, this::getFullDetails);
    }

    @NotNull
    public List<VcsCommitMetadata> getCommitMetadata(int[] rows) {
        return GraphTableModel.getDataForRows(rows, this::getCommitMetadata);
    }

    @NotNull
    public List<CommitId> getCommitIds(int[] rows) {
        return GraphTableModel.getDataForRows(rows, this::getCommitId);
    }

    @NotNull
    public List<Integer> convertToCommitIds(@NotNull List<Integer> rows) {
        return ContainerUtil.map(rows, (com.intellij.util.Function)((NotNullFunction)this::getIdAtRow));
    }

    @NotNull
    private Iterable<Integer> getCommitsToPreload(final int row2) {
        final int maxRows = this.getRowCount();
        return () -> new Iterator<Integer>(){
            private int myRowIndex;
            {
                this.myRowIndex = Math.max(0, row2 - 20);
            }

            @Override
            public boolean hasNext() {
                return this.myRowIndex < row2 + 40 && this.myRowIndex < maxRows;
            }

            @Override
            public Integer next() {
                int nextRow = this.myRowIndex++;
                return GraphTableModel.this.getIdAtRow(nextRow);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing elements is not supported.");
            }
        };
    }

    @NotNull
    private static <T> List<T> getDataForRows(final int[] rows, final @NotNull Function<? super Integer, ? extends T> dataGetter) {
        return new AbstractList<T>(){

            @Override
            @NotNull
            public T get(int index) {
                return dataGetter.apply(rows[index]);
            }

            @Override
            public int size() {
                return rows.length;
            }
        };
    }
}

