/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.highlighters;

import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.util.VcsUserUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class MyCommitsHighlighter
implements VcsLogHighlighter {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUi myLogUi;
    private boolean myShouldHighlightUser = false;

    public MyCommitsHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
        this.myLogData = logData;
        this.myLogUi = logUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails details, boolean isSelected) {
        VcsUser currentUser;
        if (!this.myLogUi.isHighlighterEnabled("MY_COMMITS")) {
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        if (this.myShouldHighlightUser && (currentUser = this.myLogData.getCurrentUser().get(details.getRoot())) != null && VcsUserUtil.isSamePerson(currentUser, details.getAuthor())) {
            return VcsCommitStyleFactory.bold();
        }
        return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        this.myShouldHighlightUser = !this.isSingleUser() && !MyCommitsHighlighter.isFilteredByCurrentUser(dataPack.getFilters());
    }

    private boolean isSingleUser() {
        THashSet users = new THashSet(this.myLogData.getCurrentUser().values(), (TObjectHashingStrategy)new VcsUserUtil.VcsUserHashingStrategy());
        return this.myLogData.getUserRegistry().all((Function1<? super VcsUser, Boolean>)((Function1)user -> users.contains(user)));
    }

    private static boolean isFilteredByCurrentUser(@NotNull VcsLogFilterCollection filters) {
        VcsLogUserFilter userFilter = (VcsLogUserFilter)filters.get(VcsLogFilterCollection.USER_FILTER);
        if (userFilter == null) {
            return false;
        }
        return Collections.singleton("*").containsAll(userFilter.getValuesAsText());
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public static final String ID = "MY_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            return new MyCommitsHighlighter(logData, logUi);
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            return VcsLogBundle.message((String)"vcs.log.action.highlight.my.commits", (Object[])new Object[0]);
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }
    }
}

