/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.comparison.TrimUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import com.intellij.vcs.commit.message.SubjectLimitInspection;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommitPresentationUtil {
    @NotNull
    private static final Pattern HASH_PATTERN = Pattern.compile("[0-9a-f]{7,40}", 2);
    @NotNull
    private static final String GO_TO_HASH = "go-to-hash:";
    @NotNull
    private static final String SHOW_HIDE_BRANCHES = "show-hide-branches";
    private static final String ELLIPSIS = "...";
    private static final int BIG_CUT_SIZE = 10;
    private static final double EPSILON = 1.5;

    public static boolean isShowHideBranches(@NotNull HyperlinkEvent e) {
        return SHOW_HIDE_BRANCHES.equals(e.getDescription());
    }

    public static boolean isGoToHash(@NotNull HyperlinkEvent e) {
        return e.getDescription().startsWith(GO_TO_HASH);
    }

    @NotNull
    public static String getAuthorPresentation(@NotNull VcsShortCommitDetails details) {
        String authorString = VcsUserUtil.getShortPresentation(details.getAuthor());
        return authorString + (VcsUserUtil.isSamePerson(details.getAuthor(), details.getCommitter()) ? "" : "*");
    }

    @NotNull
    private static String escapeMultipleSpaces(@NotNull String text2) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == ' ') {
                if (i == text2.length() - 1 || text2.charAt(i + 1) != ' ') {
                    result2.append(' ');
                    continue;
                }
                result2.append("&nbsp;");
                continue;
            }
            result2.append(text2.charAt(i));
        }
        return result2.toString();
    }

    @NotNull
    private static Set<String> findHashes(@NotNull String text2) {
        HashSet<String> result2 = new HashSet<String>();
        Matcher matcher = HASH_PATTERN.matcher(text2);
        while (matcher.find()) {
            result2.add(matcher.group());
        }
        return result2;
    }

    @NotNull
    private static String replaceHashes(@NotNull String s, @NotNull Set<String> resolvedHashes) {
        Matcher matcher = HASH_PATTERN.matcher(s);
        StringBuffer result2 = new StringBuffer();
        while (matcher.find()) {
            String hash = matcher.group();
            if (resolvedHashes.contains(hash)) {
                hash = XmlStringUtil.formatLink((String)(GO_TO_HASH + hash), (String)hash);
            }
            matcher.appendReplacement(result2, hash);
        }
        matcher.appendTail(result2);
        return result2.toString();
    }

    @NotNull
    private static Set<String> findHashes(@NotNull Project project, @NotNull String message) {
        HashSet<String> unresolvedHashes = new HashSet<String>();
        IssueLinkHtmlRenderer.formatTextWithLinks(project, message, (Convertor<? super String, String>)((Convertor)s -> {
            unresolvedHashes.addAll(CommitPresentationUtil.findHashes(s));
            return s;
        }));
        return unresolvedHashes;
    }

    @NotNull
    private static String formatCommitText(@NotNull Project project, @NotNull String fullMessage, @NotNull Set<String> resolvedHashes) {
        fullMessage = VcsUtil.trimCommitMessageToSaneSize((String)fullMessage);
        Font font = FontUtil.getCommitMessageFont();
        Convertor convertor = s -> CommitPresentationUtil.replaceHashes(s, resolvedHashes);
        int separator = fullMessage.indexOf("\n\n");
        String subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
        String description = fullMessage.substring(subject.length());
        if (subject.contains("\n")) {
            return CommitPresentationUtil.formatText(project, fullMessage, font, font.getStyle(), (Convertor<? super String, String>)convertor);
        }
        if (CommitPresentationUtil.isSubjectMarginEnabled(project)) {
            int margin = CommitMessageInspectionProfile.getSubjectRightMargin(project);
            if ((double)subject.length() > (double)margin * 1.5) {
                int placeToCut;
                for (int i = placeToCut = margin - ELLIPSIS.length(); i >= Math.max(margin - 10, 10); --i) {
                    if (subject.charAt(i) != ' ') continue;
                    placeToCut = i;
                    break;
                }
                String tail = subject.substring(placeToCut);
                if (TrimUtil.isPunctuation((char)(subject = subject.substring(0, placeToCut)).charAt(placeToCut - 1))) {
                    tail = StringUtil.trimStart((String)tail, (String)" ");
                } else {
                    subject = subject + ELLIPSIS;
                    tail = ELLIPSIS + tail;
                }
                description = "\n\n" + tail + description;
            }
        }
        return "<b>" + CommitPresentationUtil.formatText(project, subject, font, 1, (Convertor<? super String, String>)convertor) + "</b>" + CommitPresentationUtil.formatText(project, description, font, font.getStyle(), (Convertor<? super String, String>)convertor);
    }

    public static boolean isSubjectMarginEnabled(@NotNull Project project) {
        return CommitMessageInspectionProfile.getInstance(project).isToolEnabled(SubjectLimitInspection.class);
    }

    @NotNull
    private static String formatText(@NotNull Project project, @NotNull String text2, @NotNull Font font, int style, @NotNull Convertor<? super String, String> convertor) {
        return FontUtil.getHtmlWithFonts(CommitPresentationUtil.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(project, text2, convertor)), style, font);
    }

    @NotNull
    @Nls
    private static String getAuthorAndCommitterText(@NotNull VcsUser author, long authorTime, @NotNull VcsUser committer, long commitTime) {
        String authorText = VcsLogBundle.message((String)"vcs.log.details.author.on.date.at.time", (Object[])new Object[]{CommitPresentationUtil.getAuthorName(author), DateFormatUtil.formatDate((long)authorTime), DateFormatUtil.formatTime((long)authorTime)});
        String committerText = null;
        if (!VcsUserUtil.isSamePerson(author, committer)) {
            committerText = CommitPresentationUtil.getCommitterText(committer, commitTime != authorTime ? Long.valueOf(commitTime) : null);
        } else if (authorTime != commitTime) {
            committerText = CommitPresentationUtil.getCommitterText(null, commitTime);
        }
        authorText = authorText + (committerText != null ? "<br/>" + committerText : "");
        return authorText;
    }

    @NotNull
    @Nls
    private static String getCommitterText(@Nullable VcsUser committer, @Nullable Long commitTime) {
        if (committer == null && commitTime == null) {
            return "";
        }
        String graySpan = "<span style='color:#" + ColorUtil.toHex((Color)JBColor.GRAY) + "'>";
        StringBuilder builder = new StringBuilder(graySpan);
        if (commitTime == null) {
            boolean withEmail = !committer.getEmail().isEmpty();
            String by = VcsUserUtil.getShortPresentation(committer) + (withEmail ? "</span>" + CommitPresentationUtil.getEmailText(committer) + graySpan : "");
            builder.append(VcsLogBundle.message((String)"vcs.log.details.committer.info.user", (Object[])new Object[]{by}));
            builder.append("</span>");
            return builder.toString();
        }
        String date = DateFormatUtil.formatDate((long)commitTime);
        String time = DateFormatUtil.formatTime((long)commitTime);
        if (committer != null) {
            boolean withEmail = !committer.getEmail().isEmpty();
            String by = VcsUserUtil.getShortPresentation(committer) + (withEmail ? "</span>" + CommitPresentationUtil.getEmailText(committer) + graySpan : "");
            String committedBy = VcsLogBundle.message((String)"vcs.log.details.committer.info.user.date.time", (Object[])new Object[]{by, date, time});
            builder.append(committedBy);
        } else {
            String committed = VcsLogBundle.message((String)"vcs.log.details.committer.info.date.time", (Object[])new Object[]{date, time});
            builder.append(committed);
        }
        builder.append("</span>");
        return builder.toString();
    }

    @NotNull
    private static String getAuthorName(@NotNull VcsUser user) {
        String username = VcsUserUtil.getShortPresentation(user);
        return user.getEmail().isEmpty() ? username : username + CommitPresentationUtil.getEmailText(user);
    }

    @NotNull
    @NonNls
    private static String getEmailText(@NotNull VcsUser user) {
        return " " + XmlStringUtil.formatLink((String)("mailto:" + user.getEmail()), (String)("&lt;" + user.getEmail() + "&gt;"));
    }

    @NotNull
    @Nls
    private static String formatCommitHashAndAuthor(@NotNull VcsCommitMetadata commit) {
        return CommitPresentationUtil.formatCommitHashAndAuthor((Hash)commit.getId(), commit.getAuthor(), commit.getAuthorTime(), commit.getCommitter(), commit.getCommitTime());
    }

    @NotNull
    @Nls
    public static String formatCommitHashAndAuthor(@NotNull Hash commitId, @NotNull VcsUser author, long authorTime, @NotNull VcsUser committer, long commitTime) {
        Font font = FontUtil.getCommitMetadataFont();
        return FontUtil.getHtmlWithFonts(commitId.toShortString() + " " + CommitPresentationUtil.getAuthorAndCommitterText(author, authorTime, committer, commitTime), font.getStyle(), font);
    }

    @NotNull
    @Nls
    public static String getBranchesText(@Nullable List<String> branches, boolean expanded, int availableWidth, @NotNull FontMetrics metrics) {
        int tailWidth;
        if (branches == null) {
            return VcsLogBundle.message((String)"vcs.log.details.in.branches.loading", (Object[])new Object[0]);
        }
        if (branches.isEmpty()) {
            return VcsLogBundle.message((String)"vcs.log.details.in.branches.empty", (Object[])new Object[0]);
        }
        String head = VcsLogBundle.message((String)"vcs.log.details.in.branches", (Object[])new Object[]{branches.size()}) + " ";
        if (expanded) {
            return head + XmlStringUtil.formatLink((String)SHOW_HIDE_BRANCHES, (String)VcsLogBundle.message((String)"vcs.log.details.in.branches.hide", (Object[])new Object[0])) + "<br/>" + StringUtil.join(branches, (String)"<br/>");
        }
        String tail = "\u2026 " + XmlStringUtil.formatLink((String)SHOW_HIDE_BRANCHES, (String)VcsLogBundle.message((String)"vcs.log.details.in.branches.show.all", (Object[])new Object[0]));
        int headWidth = metrics.stringWidth(head);
        if (availableWidth <= headWidth + (tailWidth = metrics.stringWidth(StringUtil.removeHtmlTags((String)tail)))) {
            return head + tail;
        }
        availableWidth -= headWidth;
        StringBuilder branchesText = new StringBuilder();
        for (int i = 0; i < branches.size(); ++i) {
            String branch = branches.get(i) + (i != branches.size() - 1 ? ", " : "");
            int branchWidth = metrics.stringWidth(branch);
            if (branchWidth + tailWidth < availableWidth) {
                branchesText.append(branch);
                availableWidth -= branchWidth;
                continue;
            }
            StringBuilder shortenedBranch = new StringBuilder();
            for (char c : branch.toCharArray()) {
                if (metrics.stringWidth(shortenedBranch.toString() + c) + tailWidth >= availableWidth) break;
                shortenedBranch.append(c);
            }
            branchesText.append((CharSequence)shortenedBranch);
            branchesText.append(tail);
            break;
        }
        return head + branchesText;
    }

    @NotNull
    public static CommitPresentation buildPresentation(@NotNull Project project, @NotNull VcsCommitMetadata commit, @NotNull Set<? super String> unresolvedHashes) {
        String rawMessage = commit.getFullMessage();
        String hashAndAuthor = CommitPresentationUtil.formatCommitHashAndAuthor(commit);
        Set<String> unresolvedHashesForCommit = CommitPresentationUtil.findHashes(project, rawMessage);
        if (unresolvedHashesForCommit.isEmpty()) {
            return new CommitPresentation(project, commit.getRoot(), rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }
        unresolvedHashes.addAll(unresolvedHashesForCommit);
        return new UnresolvedPresentation(project, commit.getRoot(), rawMessage, hashAndAuthor);
    }

    public static class CommitPresentation {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final String myRawMessage;
        @NotNull
        protected final String myHashAndAuthor;
        @NotNull
        protected final VirtualFile myRoot;
        @NotNull
        private final MultiMap<String, CommitId> myResolvedHashes;

        public CommitPresentation(@NotNull Project project, @NotNull VirtualFile root, @NotNull String rawMessage, @NotNull String hashAndAuthor, @NotNull MultiMap<String, CommitId> resolvedHashes) {
            this.myProject = project;
            this.myRoot = root;
            this.myRawMessage = rawMessage;
            this.myHashAndAuthor = hashAndAuthor;
            this.myResolvedHashes = resolvedHashes;
        }

        @NotNull
        public String getText() {
            return CommitPresentationUtil.formatCommitText(this.myProject, this.myRawMessage, this.myResolvedHashes.keySet());
        }

        @NotNull
        public String getHashAndAuthor() {
            return this.myHashAndAuthor;
        }

        @Nullable
        public CommitId parseTargetCommit(@NotNull HyperlinkEvent e) {
            if (!e.getDescription().startsWith(CommitPresentationUtil.GO_TO_HASH)) {
                return null;
            }
            String hash = e.getDescription().substring(CommitPresentationUtil.GO_TO_HASH.length());
            Collection ids = this.myResolvedHashes.get((Object)hash);
            if (ids.size() <= 1) {
                return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
            }
            for (CommitId id : ids) {
                if (!this.myRoot.equals(id.getRoot())) continue;
                return id;
            }
            return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
        }

        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            return this;
        }

        public boolean isResolved() {
            return true;
        }
    }

    private static class UnresolvedPresentation
    extends CommitPresentation {
        UnresolvedPresentation(@NotNull Project project, @NotNull VirtualFile root, @NotNull String rawMessage, @NotNull String hashAndAuthor) {
            super(project, root, rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }

        @Override
        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            return new CommitPresentation(this.myProject, this.myRoot, this.myRawMessage, this.myHashAndAuthor, resolvedHashes);
        }

        @Override
        public boolean isResolved() {
            return false;
        }
    }
}

