/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MultipleValueFilterPopupComponent<Filter, Model extends FilterModel<Filter>>
extends FilterPopupComponent<Filter, Model> {
    private static final int MAX_FILTER_VALUE_LENGTH = 20;
    @NotNull
    protected final MainVcsLogUiProperties myUiProperties;
    @NonNls
    @NotNull
    private final String myName;

    MultipleValueFilterPopupComponent(@NonNls @NotNull String filterName, @NotNull Supplier<String> displayName, @NotNull MainVcsLogUiProperties uiProperties, @NotNull Model filterModel) {
        super(displayName, filterModel);
        this.myName = filterName;
        this.myUiProperties = uiProperties;
    }

    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        return this.myUiProperties.getRecentlyFilteredGroups(this.myName);
    }

    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        this.myUiProperties.addRecentlyFilteredGroup(this.myName, this.parseLocalizedValues(values));
    }

    @NotNull
    protected abstract List<String> getAllValues();

    @Nullable
    protected abstract Filter createFilter(@NotNull List<String> var1);

    @NotNull
    protected abstract List<String> getFilterValues(@NotNull Filter var1);

    @NotNull
    protected ActionGroup createRecentItemsActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        List<List<String>> recentlyFiltered = this.getRecentValuesFromSettings();
        if (!recentlyFiltered.isEmpty()) {
            group.addSeparator(VcsLogBundle.message((String)"vcs.log.filter.recent", (Object[])new Object[0]));
            for (List<String> recentGroup : recentlyFiltered) {
                if (recentGroup.isEmpty()) continue;
                group.add((AnAction)new PredefinedValueAction(recentGroup));
            }
            group.addSeparator();
        }
        return group;
    }

    @Override
    @NotNull
    protected String getText(@NotNull Filter filter) {
        return MultipleValueFilterPopupComponent.displayableText(this.getLocalizedValues(this.getFilterValues(filter)), 20);
    }

    @Override
    @Nls
    protected String getToolTip(@NotNull Filter filter) {
        return this.getTooltip(this.getFilterValues(filter));
    }

    @NotNull
    protected String getTooltip(@NotNull Collection<String> values) {
        return StringUtil.join(this.getLocalizedValues(values), (String)", ");
    }

    @NotNull
    protected abstract List<String> parseLocalizedValues(@NotNull Collection<String> var1);

    @NotNull
    protected abstract List<String> getLocalizedValues(@NotNull Collection<String> var1);

    @NotNull
    protected AnAction createSelectMultipleValuesAction() {
        return new SelectMultipleValuesAction();
    }

    @Nullable
    protected MultilinePopupBuilder.CompletionPrefixProvider getCompletionPrefixProvider() {
        return null;
    }

    @NotNull
    protected String getActionName(@NotNull List<String> values) {
        List<String> localizedValues = this.getLocalizedValues(values);
        if (localizedValues.size() == 1) {
            return (String)Objects.requireNonNull(ContainerUtil.getFirstItem(localizedValues));
        }
        return MultipleValueFilterPopupComponent.displayableText(localizedValues, 40);
    }

    @NotNull
    static String displayableText(@NotNull Collection<String> values, int maxLength) {
        String text2 = values.size() == 1 ? (String)Objects.requireNonNull(ContainerUtil.getFirstItem(values)) : StringUtil.join(values, (String)"|");
        return StringUtil.shortenTextWithEllipsis((String)text2, (int)maxLength, (int)0, (boolean)true);
    }

    private class SelectMultipleValuesAction
    extends DumbAwareAction {
        @NotNull
        private final Collection<String> myVariants;

        SelectMultipleValuesAction() {
            super(VcsLogBundle.messagePointer((String)"vcs.log.filter.action.select", (Object[])new Object[0]));
            this.myVariants = MultipleValueFilterPopupComponent.this.getAllValues();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Object filter = MultipleValueFilterPopupComponent.this.myFilterModel.getFilter();
            List<String> values = filter == null ? Collections.emptyList() : MultipleValueFilterPopupComponent.this.getLocalizedValues(MultipleValueFilterPopupComponent.this.getFilterValues(filter));
            final MultilinePopupBuilder popupBuilder = new MultilinePopupBuilder(project, this.myVariants, this.getPopupText(values), MultipleValueFilterPopupComponent.this.getCompletionPrefixProvider());
            JBPopup popup = popupBuilder.createPopup();
            popup.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event.isOk()) {
                        List<String> selectedValues = MultipleValueFilterPopupComponent.this.parseLocalizedValues(popupBuilder.getSelectedValues());
                        if (selectedValues.isEmpty()) {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(null);
                        } else {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(MultipleValueFilterPopupComponent.this.createFilter(selectedValues));
                            MultipleValueFilterPopupComponent.this.rememberValuesInSettings(selectedValues);
                        }
                    }
                }
            });
            popup.showUnderneathOf((Component)MultipleValueFilterPopupComponent.this);
        }

        @NotNull
        private String getPopupText(@Nullable Collection<String> selectedValues) {
            return selectedValues == null || selectedValues.isEmpty() ? "" : StringUtil.join(selectedValues, (String)"\n");
        }
    }

    protected class PredefinedValueAction
    extends DumbAwareAction {
        @NotNull
        protected final List<String> myValues;
        private final boolean myAddToRecent;

        public PredefinedValueAction(List<String> values) {
            this(values, null, true);
        }

        public PredefinedValueAction(@Nullable List<String> values, Supplier<String> displayName, boolean addToRecent) {
            super(null, MultipleValueFilterPopupComponent.this.getTooltip(values), null);
            this.getTemplatePresentation().setText(displayName != null ? displayName : () -> MultipleValueFilterPopupComponent.this.getActionName(values), false);
            this.myValues = values;
            this.myAddToRecent = addToRecent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(MultipleValueFilterPopupComponent.this.createFilter(this.myValues));
            if (this.myAddToRecent) {
                MultipleValueFilterPopupComponent.this.rememberValuesInSettings(this.myValues);
            }
        }
    }
}

