/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.google.common.primitives.Chars;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.AutoPopupSupportingListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultilinePopupBuilder {
    static final char[] SEPARATORS = new char[]{'|', '\n'};
    @NotNull
    private final EditorTextField myTextField;

    MultilinePopupBuilder(@NotNull Project project, @NotNull Collection<String> values, @NotNull String initialValue, @Nullable CompletionPrefixProvider completionPrefixProvider) {
        this.myTextField = MultilinePopupBuilder.createTextField(project, values, completionPrefixProvider, initialValue);
    }

    @NotNull
    private static EditorTextField createTextField(@NotNull Project project, Collection<String> values, @Nullable CompletionPrefixProvider completionPrefixProvider, @NotNull String initialValue) {
        TextFieldWithCompletion textField = new TextFieldWithCompletion(project, (TextCompletionProvider)new MyCompletionProvider(values, completionPrefixProvider), initialValue, false, true, false){

            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                SoftWrapsEditorCustomization.ENABLED.customize(editor);
                return editor;
            }
        };
        textField.setBorder((Border)new CompoundBorder(JBUI.Borders.empty((int)2), textField.getBorder()));
        return textField;
    }

    @NotNull
    JBPopup createPopup() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myTextField, "Center");
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)this.myTextField).setCancelOnClickOutside(true).setAdText(VcsLogBundle.message((String)"vcs.log.filter.popup.advertisement.with.key.text", (Object[])new Object[]{KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.CTRL_ENTER.getShortcuts())})).setRequestFocus(true).setResizable(true).setMayBeParent(true);
        final JBPopup popup = builder.createPopup();
        popup.setMinimumSize((Dimension)new JBDimension(200, 90));
        DumbAwareAction okAction = new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.unregisterCustomShortcutSet(popup.getContent());
                popup.closeOk(e.getInputEvent());
            }
        };
        okAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, popup.getContent());
        AutoPopupSupportingListener.installOn((JBPopup)popup);
        return popup;
    }

    @NotNull
    List<String> getSelectedValues() {
        return ContainerUtil.mapNotNull((Iterable)StringUtil.tokenize((String)this.myTextField.getText(), (String)new String(SEPARATORS)), value -> {
            String trimmed = value.trim();
            return trimmed.isEmpty() ? null : trimmed;
        });
    }

    private static class MyCompletionProvider
    extends ValuesCompletionProvider.ValuesCompletionProviderDumbAware<String> {
        @Nullable
        private final CompletionPrefixProvider myCompletionPrefixProvider;

        MyCompletionProvider(@NotNull Collection<String> values, @Nullable CompletionPrefixProvider completionPrefixProvider) {
            super((TextCompletionValueDescriptor)new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), Chars.asList((char[])SEPARATORS), values, false);
            this.myCompletionPrefixProvider = completionPrefixProvider;
        }

        @Nullable
        public String getPrefix(@NotNull String text2, int offset) {
            if (this.myCompletionPrefixProvider != null) {
                return this.myCompletionPrefixProvider.getPrefix(text2, offset);
            }
            return super.getPrefix(text2, offset);
        }

        @Nullable
        public String getAdvertisement() {
            return VcsLogBundle.message((String)"vcs.log.filter.popup.advertisement.text", (Object[])new Object[0]);
        }
    }

    static interface CompletionPrefixProvider {
        public String getPrefix(@NotNull String var1, int var2);
    }
}

