/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class VcsLogCreatePatchActionProvider
implements AnActionExtensionProvider {
    private final boolean mySilentClipboard;

    private VcsLogCreatePatchActionProvider(boolean silentClipboard) {
        this.mySilentClipboard = silentClipboard;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        return e.getData(VcsLogDataKeys.VCS_LOG_UI) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        e.getPresentation().setEnabled(changes != null && changes.length > 0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, this);
        Change[] changes = (Change[])e.getRequiredData(VcsDataKeys.CHANGES);
        String commitMessage2 = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        CreatePatchFromChangesAction.createPatch(e.getProject(), commitMessage2, Arrays.asList(changes), this.mySilentClipboard);
    }

    public static class Clipboard
    extends VcsLogCreatePatchActionProvider {
        public Clipboard() {
            super(true);
        }
    }

    public static class Dialog
    extends VcsLogCreatePatchActionProvider {
        public Dialog() {
            super(false);
        }
    }
}

