/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleLogColumnsActionGroup
extends ActionGroup
implements DumbAware {
    public ToggleLogColumnsActionGroup() {
        super(VcsLogBundle.message((String)"action.title.select.columns.to.see", (Object[])new Object[0]), VcsLogBundle.message((String)"action.description.select.columns.to.see", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        this.setPopup(ToggleLogColumnsActionGroup.isPopup(e));
        e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e));
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (e != null && !ToggleLogColumnsActionGroup.isPopup(e)) {
            actions.add(Separator.create((String)VcsLogBundle.message((String)"action.title.select.columns.to.see", (Object[])new Object[0])));
        }
        for (VcsLogColumn column : VcsLogColumn.DYNAMIC_COLUMNS) {
            actions.add((Object)new ToggleColumnAction(column));
        }
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    private static boolean isPopup(@NotNull AnActionEvent e) {
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) == null;
    }

    private static boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        return properties != null && properties.exists(CommonUiProperties.COLUMN_ORDER);
    }

    private static class ToggleColumnAction
    extends ToggleAction
    implements DumbAware {
        private final int myIndex;

        private ToggleColumnAction(@NotNull VcsLogColumn column) {
            super(() -> column.getLocalizedName());
            this.myIndex = column.ordinal();
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            if (properties != null && properties.exists(CommonUiProperties.COLUMN_ORDER)) {
                List<Integer> columnOrder = properties.get(CommonUiProperties.COLUMN_ORDER);
                return columnOrder.contains(this.myIndex);
            }
            return false;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            assert (properties.exists(CommonUiProperties.COLUMN_ORDER));
            ArrayList<Integer> columnOrder = new ArrayList<Integer>((Collection)properties.get(CommonUiProperties.COLUMN_ORDER));
            if (columnOrder.contains(this.myIndex)) {
                columnOrder.remove((Object)this.myIndex);
            } else {
                columnOrder.add(this.myIndex);
            }
            properties.set(CommonUiProperties.COLUMN_ORDER, columnOrder);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e));
        }
    }
}

