/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshLogAction
extends RefreshAction {
    private static final Logger LOG = Logger.getInstance(RefreshLogAction.class);

    public RefreshLogAction() {
        super(VcsLogBundle.message((String)"action.name.refresh.log", (Object[])new Object[0]), VcsLogBundle.message((String)"action.description.refresh.log", (Object[])new Object[0]), AllIcons.Actions.Refresh);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VisiblePackRefresher refresher;
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        VcsLogManager logManager = (VcsLogManager)e.getRequiredData(VcsLogInternalDataKeys.LOG_MANAGER);
        VcsLogUi ui2 = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        if (ui2 instanceof VcsLogUiEx && !(refresher = ((VcsLogUiEx)ui2).getRefresher()).isValid()) {
            String message = "Trying to refresh invalid log tab '" + ui2.getId() + "'.";
            if (!logManager.getDataManager().getProgress().isRunning()) {
                LOG.error(message, RefreshLogAction.collectDiagnosticInformation(e.getProject(), logManager));
            } else {
                LOG.warn(message);
            }
            refresher.setValid(true, false);
        }
        logManager.getDataManager().refresh(VcsLogUtil.getVisibleRoots(ui2));
    }

    public void update(@NotNull AnActionEvent e) {
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        e.getPresentation().setEnabledAndVisible(logManager != null && e.getData(VcsLogDataKeys.VCS_LOG_UI) != null);
    }

    private static Attachment @NotNull [] collectDiagnosticInformation(@Nullable Project project, @NotNull VcsLogManager logManager) {
        ToolWindow toolWindow;
        ArrayList<Attachment> result2 = new ArrayList<Attachment>();
        result2.add(new Attachment("log-windows.txt", "Log Windows:\n" + logManager.getLogWindowsInformation()));
        if (project != null && (toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control")) != null) {
            String contentDump = StringUtil.join((Object[])toolWindow.getContentManager().getContents(), content2 -> {
                if (content2 instanceof TabbedContent) {
                    return content2.toString() + ", tabs=[" + StringUtil.join((Collection)((TabbedContent)content2).getTabs(), pair -> (String)pair.first, (String)", ") + "]";
                }
                return content2.toString();
            }, (String)"\n");
            result2.add(new Attachment("vcs-tool-window-content.txt", "Tool Window " + toolWindow.getTitle() + " (" + toolWindow.getType() + "):\n" + contentDump));
        }
        return result2.toArray(Attachment.EMPTY_ARRAY);
    }
}

