/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.navigation.History;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PairFunction;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.frame.VcsLogEditorDiffPreview;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUiImpl
extends AbstractVcsLogUi
implements MainVcsLogUi {
    @NonNls
    private static final String HELP_ID = "reference.changesToolWindow.log";
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final MyVcsLogUiPropertiesListener myPropertiesListener;
    @NotNull
    private final History myHistory;
    @NotNull
    private final EventDispatcher<MainVcsLogUi.VcsLogFilterListener> myFilterListenerDispatcher = EventDispatcher.create(MainVcsLogUi.VcsLogFilterListener.class);

    public VcsLogUiImpl(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @Nullable VcsLogFilterCollection initialFilters) {
        super(id, logData, manager, refresher);
        this.myUiProperties = uiProperties;
        VcsLogFilterUiEx filterUi = this.createFilterUi((Consumer<VcsLogFilterCollection>)((Consumer)filters -> this.applyFiltersAndUpdateUi((VcsLogFilterCollection)filters)), initialFilters, this);
        this.myMainFrame = this.createMainFrame(logData, uiProperties, filterUi);
        VcsLogUiUtil.installHighlighters(this, f -> true);
        this.myPropertiesListener = new MyVcsLogUiPropertiesListener();
        this.myUiProperties.addChangeListener(this.myPropertiesListener);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(this);
        this.applyFiltersAndUpdateUi(this.myMainFrame.getFilterUi().getFilters());
    }

    @NotNull
    protected MainFrame createMainFrame(@NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogFilterUiEx filterUi) {
        boolean isDiffPreviewAsEditor = VcsLogUiUtil.isDiffPreviewInEditor();
        MainFrame mainFrame = new MainFrame(logData, this, uiProperties, filterUi, !isDiffPreviewAsEditor, this);
        if (isDiffPreviewAsEditor) {
            new VcsLogEditorDiffPreview(this.myProject, this.myUiProperties, mainFrame);
        }
        return mainFrame;
    }

    @NotNull
    protected VcsLogFilterUiEx createFilterUi(@NotNull Consumer<VcsLogFilterCollection> filterConsumer, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
        return new VcsLogClassicFilterUi(this.myLogData, filterConsumer, this.myUiProperties, this.myColorManager, filters, parentDisposable);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myMainFrame.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myPropertiesListener.onShowLongEdgesChanged();
    }

    @NotNull
    protected MainFrame getMainFrame() {
        return this.myMainFrame;
    }

    @Override
    protected <T> void handleCommitNotFound(final @NotNull T commitId, boolean commitExists, final @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (this.getFilterUi().getFilters().isEmpty() || !commitExists) {
            super.handleCommitNotFound(commitId, commitExists, rowGetter);
            return;
        }
        ArrayList<NamedRunnable> runnables = new ArrayList<NamedRunnable>();
        runnables.add(new NamedRunnable(VcsLogBundle.message((String)"vcs.log.commit.does.not.match.view.and.reset.link", (Object[])new Object[0])){

            public void run() {
                VcsLogUiImpl.this.getFilterUi().clearFilters();
                VcsLogUiImpl.this.invokeOnChange(() -> VcsLogUiImpl.this.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create(), false), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
            }
        });
        final VcsProjectLog projectLog = VcsProjectLog.getInstance(this.myProject);
        if (projectLog.getDataManager() == this.myLogData) {
            runnables.add(new NamedRunnable(VcsLogBundle.message((String)"vcs.log.commit.does.not.match.view.in.tab.link", (Object[])new Object[0])){

                public void run() {
                    MainVcsLogUi ui2 = projectLog.openLogTab(VcsLogFilterObject.collection(new VcsLogFilter[0]));
                    if (ui2 != null) {
                        ui2.invokeOnChange(() -> ui2.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create(), false), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
                    }
                }
            });
        }
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, VcsLogUiImpl.getCommitNotFoundMessage(commitId, true), MessageType.WARNING, runnables.toArray(new NamedRunnable[0]));
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        MainVcsLogUiProperties.VcsLogHighlighterProperty property = MainVcsLogUiProperties.VcsLogHighlighterProperty.get(id);
        return this.myUiProperties.exists(property) && this.myUiProperties.get(property) != false;
    }

    protected void applyFiltersAndUpdateUi(@NotNull VcsLogFilterCollection filters) {
        this.myRefresher.onFiltersChange(filters);
        ((MainVcsLogUi.VcsLogFilterListener)this.myFilterListenerDispatcher.getMulticaster()).onFiltersChanged();
        JComponent toolbar = this.myMainFrame.getToolbar();
        toolbar.revalidate();
        toolbar.repaint();
    }

    @Override
    public void addFilterListener(@NotNull MainVcsLogUi.VcsLogFilterListener listener2) {
        this.myFilterListenerDispatcher.addListener((EventListener)listener2);
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        return this.myMainFrame.getGraphTable();
    }

    @Override
    @NotNull
    public JComponent getMainComponent() {
        return this.myMainFrame;
    }

    @Override
    @NotNull
    public VcsLogFilterUiEx getFilterUi() {
        return this.myMainFrame.getFilterUi();
    }

    @Override
    @NotNull
    public JComponent getToolbar() {
        return this.myMainFrame.getToolbar();
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties getProperties() {
        return this.myUiProperties;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    @Override
    @Nullable
    public History getNavigationHistory() {
        return this.myHistory;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesListener);
        super.dispose();
    }

    private class MyVcsLogUiPropertiesListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyVcsLogUiPropertiesListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.showDetails(VcsLogUiImpl.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (MainVcsLogUiProperties.SHOW_LONG_EDGES.equals(property)) {
                this.onShowLongEdgesChanged();
            } else if (CommonUiProperties.SHOW_ROOT_NAMES.equals(property)) {
                VcsLogUiImpl.this.getTable().rootColumnUpdated();
            } else if (MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW.equals(property)) {
                VcsLogUiImpl.this.getTable().setCompactReferencesView(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
            } else if (MainVcsLogUiProperties.SHOW_TAG_NAMES.equals(property)) {
                VcsLogUiImpl.this.getTable().setShowTagNames(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
            } else if (MainVcsLogUiProperties.LABELS_LEFT_ALIGNED.equals(property)) {
                VcsLogUiImpl.this.getTable().setLabelsLeftAligned(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.LABELS_LEFT_ALIGNED));
            } else if (MainVcsLogUiProperties.BEK_SORT_TYPE.equals(property)) {
                VcsLogUiImpl.this.myRefresher.onSortTypeChange(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE));
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                VcsLogUiImpl.this.getTable().onColumnOrderSettingChanged();
            } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
                VcsLogUiImpl.this.getTable().repaint();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                VcsLogUiImpl.this.getTable().forceReLayout(((CommonUiProperties.TableColumnProperty)property).getColumn());
            } else if (property.equals(CommonUiProperties.PREFER_COMMIT_DATE) && VcsLogUiImpl.this.getTable().getTableColumn(VcsLogColumn.DATE) != null) {
                VcsLogUiImpl.this.getTable().repaint();
            }
        }

        private void onShowLongEdgesChanged() {
            VcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController().setLongEdgesHidden(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_LONG_EDGES) == false);
        }
    }
}

