/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVcsLogUi
implements VcsLogUiEx,
Disposable {
    private static final Logger LOG = Logger.getInstance(AbstractVcsLogUi.class);
    public static final ExtensionPointName<VcsLogHighlighterFactory> LOG_HIGHLIGHTER_FACTORY_EP = ExtensionPointName.create((String)"com.intellij.logHighlighterFactory");
    @NotNull
    private final String myId;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VcsLogData myLogData;
    @NotNull
    protected final VcsLogColorManager myColorManager;
    @NotNull
    protected final VcsLog myLog;
    @NotNull
    protected final VisiblePackRefresher myRefresher;
    @NotNull
    protected final Collection<VcsLogListener> myLogListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    protected final VisiblePackChangeListener myVisiblePackChangeListener;
    @NotNull
    protected VisiblePack myVisiblePack = VisiblePack.EMPTY;

    public AbstractVcsLogUi(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull VisiblePackRefresher refresher) {
        this.myId = id;
        this.myProject = logData.getProject();
        this.myLogData = logData;
        this.myRefresher = refresher;
        this.myColorManager = manager;
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        this.myLog = new VcsLogImpl(logData, this);
        this.myVisiblePackChangeListener = visiblePack -> UIUtil.invokeLaterIfNeeded(() -> {
            if (!Disposer.isDisposed((Disposable)this)) {
                this.setVisiblePack(visiblePack);
            }
        });
        this.myRefresher.addVisiblePackChangeListener(this.myVisiblePackChangeListener);
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean permGraphChanged = this.myVisiblePack.getDataPack() != pack.getDataPack();
        this.myVisiblePack = pack;
        this.onVisiblePackUpdated(permGraphChanged);
        this.fireFilterChangeEvent(this.myVisiblePack, permGraphChanged);
        this.getTable().repaint();
    }

    protected abstract void onVisiblePackUpdated(boolean var1);

    @Override
    @NotNull
    public VisiblePackRefresher getRefresher() {
        return this.myRefresher;
    }

    @Override
    @NotNull
    public VcsLogColorManager getColorManager() {
        return this.myColorManager;
    }

    @Override
    @NotNull
    public VcsLog getVcsLog() {
        return this.myLog;
    }

    @NotNull
    public VcsLogData getLogData() {
        return this.myLogData;
    }

    public void requestMore(@NotNull Runnable onLoaded) {
        this.myRefresher.moreCommitsNeeded(onLoaded);
        this.getTable().setPaintBusy(true);
    }

    @Override
    @NotNull
    public VisiblePack getDataPack() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myVisiblePack;
    }

    @Override
    public void jumpToRow(int row2, boolean silently) {
        this.jumpTo(row2, (model, r) -> {
            if (model.getRowCount() <= r) {
                return -1;
            }
            return r;
        }, (SettableFuture<? super Boolean>)SettableFuture.create(), silently);
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        SettableFuture future2 = SettableFuture.create();
        this.jumpTo(commitHash, (model, hash) -> model.getRowOfCommit((Hash)hash, root), (SettableFuture<? super Boolean>)future2, false);
        return future2;
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> jumpToHash(@NotNull String commitHash) {
        SettableFuture future2 = SettableFuture.create();
        String trimmed = StringUtil.trim((String)commitHash, ch -> !StringUtil.containsChar((String)"()'\"`", (char)ch));
        if (!VcsLogUtil.HASH_REGEX.matcher(trimmed).matches()) {
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, VcsLogBundle.message((String)"vcs.log.commit.or.reference.not.found", (Object[])new Object[]{commitHash}), MessageType.WARNING, new NamedRunnable[0]);
            future2.set((Object)false);
            return future2;
        }
        this.jumpTo(trimmed, GraphTableModel::getRowOfCommitByPartOfHash, (SettableFuture<? super Boolean>)future2, false);
        return future2;
    }

    @Override
    public <T> void jumpTo(@NotNull T commitId, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter, @NotNull SettableFuture<? super Boolean> future2, boolean silently) {
        if (future2.isCancelled()) {
            return;
        }
        GraphTableModel model = this.getTable().getModel();
        int result2 = (Integer)rowGetter.fun((Object)model, commitId);
        if (result2 >= 0) {
            this.getTable().jumpToRow(result2);
            future2.set((Object)true);
        } else if (model.canRequestMore()) {
            model.requestToLoadMore(() -> this.jumpTo(commitId, rowGetter, future2, silently));
        } else if (!this.myVisiblePack.isFull()) {
            this.invokeOnChange(() -> this.jumpTo(commitId, rowGetter, future2, silently));
        } else {
            if (!silently) {
                this.handleCommitNotFound(commitId, result2 == -2, rowGetter);
            }
            future2.set((Object)false);
        }
    }

    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        String message = AbstractVcsLogUi.getCommitNotFoundMessage(commitId, commitExists);
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.WARNING, new NamedRunnable[0]);
    }

    @NotNull
    @Nls
    protected static <T> String getCommitNotFoundMessage(@NotNull T commitId, boolean exists) {
        return exists ? VcsLogBundle.message((String)"vcs.log.commit.does.not.match", (Object[])new Object[]{AbstractVcsLogUi.getCommitPresentation(commitId)}) : VcsLogBundle.message((String)"vcs.log.commit.not.found", (Object[])new Object[]{AbstractVcsLogUi.getCommitPresentation(commitId)});
    }

    @NotNull
    protected static <T> String getCommitPresentation(@NotNull T commitId) {
        if (commitId instanceof Hash) {
            return ((Hash)commitId).toShortString();
        }
        if (commitId instanceof String) {
            return VcsLogUtil.getShortHash((String)commitId);
        }
        return commitId.toString();
    }

    protected void showWarningWithLink(@Nls @NotNull String mainText, @Nls @NotNull String linkText, final @NotNull Runnable onClick) {
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, mainText, MessageType.WARNING, new NamedRunnable(linkText){

            public void run() {
                onClick.run();
            }
        });
    }

    public void addLogListener(@NotNull VcsLogListener listener2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.add(listener2);
    }

    public void removeLogListener(@NotNull VcsLogListener listener2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.remove(listener2);
    }

    protected void fireFilterChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (VcsLogListener listener2 : this.myLogListeners) {
            listener2.onChange((VcsLogDataPack)visiblePack, refresh2);
        }
    }

    public void invokeOnChange(@NotNull Runnable runnable) {
        this.invokeOnChange(runnable, (Condition<? super VcsLogDataPack>)Conditions.alwaysTrue());
    }

    public void invokeOnChange(final @NotNull Runnable runnable, final @NotNull Condition<? super VcsLogDataPack> condition) {
        this.addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                if (condition.value((Object)dataPack)) {
                    runnable.run();
                    AbstractVcsLogUi.this.removeLogListener(this);
                }
            }
        });
    }

    public void dispose() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        LOG.debug("Disposing VcsLogUi '" + this.myId + "'");
        this.myRefresher.removeVisiblePackChangeListener(this.myVisiblePackChangeListener);
        this.getTable().removeAllHighlighters();
        this.myVisiblePack = VisiblePack.EMPTY;
    }
}

