/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.ValueKey;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogUiPropertiesImpl<S extends State>
implements PersistentStateComponent<S>,
MainVcsLogUiProperties {
    private static final Set<VcsLogUiProperties.VcsLogUiProperty> SUPPORTED_PROPERTIES = ContainerUtil.newHashSet((Object[])new VcsLogUiProperties.VcsLogUiProperty[]{CommonUiProperties.SHOW_DETAILS, MainVcsLogUiProperties.SHOW_LONG_EDGES, MainVcsLogUiProperties.BEK_SORT_TYPE, CommonUiProperties.SHOW_ROOT_NAMES, MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, MainVcsLogUiProperties.TEXT_FILTER_REGEX});
    private final Set<VcsLogUiProperties.PropertiesChangeListener> myListeners = new LinkedHashSet<VcsLogUiProperties.PropertiesChangeListener>();
    @NotNull
    private final VcsLogApplicationSettings myAppSettings;

    public VcsLogUiPropertiesImpl(@NotNull VcsLogApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
    }

    @NotNull
    public abstract S getState();

    @Override
    @NotNull
    public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (this.myAppSettings.exists(property)) {
            return this.myAppSettings.get(property);
        }
        Object state = this.getState();
        if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            Boolean result2 = ((State)state).HIGHLIGHTERS.get(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property).getId());
            if (result2 == null) {
                return (T)Boolean.TRUE;
            }
            return (T)result2;
        }
        if (property instanceof CommonUiProperties.TableColumnProperty) {
            Integer savedWidth = ((State)state).COLUMN_WIDTH.get(((CommonUiProperties.TableColumnProperty)property).getColumnIndex());
            if (savedWidth == null) {
                return (T)Integer.valueOf(-1);
            }
            return (T)savedWidth;
        }
        TextFilterSettings filterSettings = this.getTextFilterSettings();
        return (T)property.match().ifEq(CommonUiProperties.SHOW_DETAILS).then((Object)((State)state).SHOW_DETAILS_IN_CHANGES).ifEq((ValueKey)SHOW_LONG_EDGES).then((Object)((State)state).LONG_EDGES_VISIBLE).ifEq(CommonUiProperties.SHOW_ROOT_NAMES).then((Object)((State)state).SHOW_ROOT_NAMES).ifEq((ValueKey)SHOW_ONLY_AFFECTED_CHANGES).then((Object)((State)state).SHOW_ONLY_AFFECTED_CHANGES).ifEq((ValueKey)BEK_SORT_TYPE).thenGet(() -> VcsLogUiPropertiesImpl.lambda$get$0((State)state)).ifEq((ValueKey)TEXT_FILTER_MATCH_CASE).then((Object)filterSettings.MATCH_CASE).ifEq((ValueKey)TEXT_FILTER_REGEX).then((Object)filterSettings.REGEX).get();
    }

    @Override
    public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, @NotNull T value) {
        if (this.myAppSettings.exists(property)) {
            this.myAppSettings.set(property, value);
            return;
        }
        if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
            ((State)this.getState()).SHOW_DETAILS_IN_CHANGES = (Boolean)value;
        } else if (SHOW_LONG_EDGES.equals(property)) {
            ((State)this.getState()).LONG_EDGES_VISIBLE = (Boolean)value;
        } else if (CommonUiProperties.SHOW_ROOT_NAMES.equals(property)) {
            ((State)this.getState()).SHOW_ROOT_NAMES = (Boolean)value;
        } else if (SHOW_ONLY_AFFECTED_CHANGES.equals(property)) {
            ((State)this.getState()).SHOW_ONLY_AFFECTED_CHANGES = (Boolean)value;
        } else if (BEK_SORT_TYPE.equals(property)) {
            ((State)this.getState()).BEK_SORT_TYPE = ((PermanentGraph.SortType)value).ordinal();
        } else if (TEXT_FILTER_REGEX.equals(property)) {
            this.getTextFilterSettings().REGEX = (Boolean)value;
        } else if (TEXT_FILTER_MATCH_CASE.equals(property)) {
            this.getTextFilterSettings().MATCH_CASE = (Boolean)value;
        } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            ((State)this.getState()).HIGHLIGHTERS.put(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property).getId(), (Boolean)value);
        } else if (property instanceof CommonUiProperties.TableColumnProperty) {
            ((State)this.getState()).COLUMN_WIDTH.put(((CommonUiProperties.TableColumnProperty)property).getColumnIndex(), (Integer)value);
        } else {
            throw new UnsupportedOperationException("Property " + property + " does not exist");
        }
        this.onPropertyChanged(property);
    }

    protected <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        this.myListeners.forEach(l -> l.onPropertyChanged(property));
    }

    @Override
    public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        return this.myAppSettings.exists(property) || SUPPORTED_PROPERTIES.contains(property) || property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty || property instanceof CommonUiProperties.TableColumnProperty;
    }

    @NotNull
    private TextFilterSettings getTextFilterSettings() {
        TextFilterSettings settings = ((State)this.getState()).TEXT_FILTER_SETTINGS;
        if (settings == null) {
            ((State)this.getState()).TEXT_FILTER_SETTINGS = settings = new TextFilterSettings();
        }
        return settings;
    }

    @Override
    public void saveFilterValues(@NotNull String filterName, @Nullable List<String> values) {
        if (values != null) {
            ((State)this.getState()).FILTERS.put(filterName, values);
        } else {
            ((State)this.getState()).FILTERS.remove(filterName);
        }
    }

    @Override
    @Nullable
    public List<String> getFilterValues(@NotNull String filterName) {
        return ((State)this.getState()).FILTERS.get(filterName);
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        this.myListeners.add(listener2);
        this.myAppSettings.addChangeListener(listener2);
    }

    @Override
    public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        this.myListeners.remove(listener2);
        this.myAppSettings.removeChangeListener(listener2);
    }

    private static /* synthetic */ PermanentGraph.SortType lambda$get$0(State state) {
        return PermanentGraph.SortType.values()[state.BEK_SORT_TYPE];
    }

    public static class TextFilterSettings {
        public boolean REGEX = false;
        public boolean MATCH_CASE = false;
    }

    public static class State {
        public boolean SHOW_DETAILS_IN_CHANGES = true;
        public boolean LONG_EDGES_VISIBLE = false;
        public int BEK_SORT_TYPE = 0;
        public boolean SHOW_ROOT_NAMES = false;
        public boolean SHOW_ONLY_AFFECTED_CHANGES = false;
        public Map<String, Boolean> HIGHLIGHTERS = new TreeMap<String, Boolean>();
        public Map<String, List<String>> FILTERS = new TreeMap<String, List<String>>();
        public TextFilterSettings TEXT_FILTER_SETTINGS = new TextFilterSettings();
        public Map<Integer, Integer> COLUMN_WIDTH = new HashMap<Integer, Integer>();
    }
}

