/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogEditorUtilKt;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTabsManager {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogProjectTabsProperties myUiProperties;
    private boolean myIsLogDisposing = false;

    VcsLogTabsManager(@NotNull Project project, @NotNull MessageBus messageBus, @NotNull VcsLogProjectTabsProperties uiProperties, @NotNull Disposable parent) {
        this.myProject = project;
        this.myUiProperties = uiProperties;
        messageBus.connect(parent).subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager manager) {
                VcsLogTabsManager.this.myIsLogDisposing = false;
                VcsLogTabsManager.this.createLogTabs(manager);
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager manager) {
                VcsLogTabsManager.this.myIsLogDisposing = true;
            }
        });
    }

    private void createLogTabs(@NotNull VcsLogManager manager) {
        this.myUiProperties.getTabs().forEach((id, kind) -> this.openLogTab(manager, (String)id, (VcsLogManager.LogWindowKind)((Object)kind), false, null));
    }

    @NotNull
    public Collection<String> getTabs() {
        return this.myUiProperties.getTabs().keySet();
    }

    @NotNull
    MainVcsLogUi openAnotherLogTab(@NotNull VcsLogManager manager, @Nullable VcsLogFilterCollection filters, @NotNull VcsLogManager.LogWindowKind kind) {
        return this.openLogTab(manager, VcsLogTabsManager.generateTabId(this.myProject), kind, true, filters);
    }

    @NotNull
    private MainVcsLogUi openLogTab(@NotNull VcsLogManager manager, @NotNull String tabId, @NotNull VcsLogManager.LogWindowKind kind, boolean focus, @Nullable VcsLogFilterCollection filters) {
        MainVcsLogUi ui2;
        if (filters != null) {
            this.myUiProperties.resetState(tabId);
        }
        PersistentVcsLogUiFactory factory = new PersistentVcsLogUiFactory(manager.getMainLogUiFactory(tabId, filters), kind);
        if (kind == VcsLogManager.LogWindowKind.EDITOR) {
            ui2 = VcsLogEditorUtilKt.openLogTab(this.myProject, manager, VcsLogTabsManager.getFullName(tabId), factory, focus);
            ui2.addFilterListener(() -> VcsLogEditorUtilKt.updateTabName(this.myProject, ui2));
        } else if (kind == VcsLogManager.LogWindowKind.TOOL_WINDOW) {
            ui2 = VcsLogContentUtil.openLogTab(this.myProject, manager, VcsLogContentProvider.TAB_NAME, () -> VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]), u -> VcsLogTabsManager.generateShortDisplayName(u), factory, focus);
            ui2.addFilterListener(() -> VcsLogContentUtil.updateLogUiName(this.myProject, ui2));
        } else {
            throw new UnsupportedOperationException("Only log in editor or tool window is supported");
        }
        return ui2;
    }

    @NotNull
    private static String generateShortDisplayName(@NotNull VcsLogUi ui2) {
        VcsLogFilterCollection filters = ui2.getFilterUi().getFilters();
        if (filters.isEmpty()) {
            return "";
        }
        return StringUtil.shortenTextWithEllipsis((String)VcsLogFiltersKt.getPresentation(filters), (int)150, (int)20);
    }

    @NotNull
    private static String getFullName(@NotNull String shortName) {
        return ContentUtilEx.getFullName((String)VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]), (String)shortName);
    }

    @NotNull
    public static String generateDisplayName(@NotNull VcsLogUi ui2) {
        return VcsLogTabsManager.getFullName(VcsLogTabsManager.generateShortDisplayName(ui2));
    }

    @NotNull
    private static String generateTabId(@NotNull Project project) {
        Set existingIds = ContainerUtil.union(VcsLogContentUtil.getExistingLogIds(project), VcsLogEditorUtilKt.getExistingLogIds(project));
        int i = 1;
        String idString;
        while (existingIds.contains(idString = Integer.toString(i))) {
            ++i;
        }
        return idString;
    }

    private class PersistentVcsLogUiFactory
    implements VcsLogManager.VcsLogUiFactory<MainVcsLogUi> {
        @NotNull
        private final VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> myFactory;
        @NotNull
        private final VcsLogManager.LogWindowKind myLogWindowKind;

        PersistentVcsLogUiFactory(@NotNull VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> factory, VcsLogManager.LogWindowKind kind) {
            this.myFactory = factory;
            this.myLogWindowKind = kind;
        }

        @Override
        public MainVcsLogUi createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            MainVcsLogUi ui2 = this.myFactory.createLogUi(project, logData);
            VcsLogTabsManager.this.myUiProperties.addTab(ui2.getId(), this.myLogWindowKind);
            Disposer.register((Disposable)ui2, () -> {
                if (Disposer.isDisposing((Disposable)VcsLogTabsManager.this.myProject) || VcsLogTabsManager.this.myIsLogDisposing) {
                    return;
                }
                VcsLogTabsManager.this.myUiProperties.removeTab(ui2.getId());
            });
            return ui2;
        }
    }
}

