/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import com.intellij.vcs.log.util.FilterConfigMigrationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="Vcs.Log.Tabs.Properties", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class VcsLogProjectTabsProperties
implements PersistentStateComponent<State>,
VcsLogTabsProperties {
    @NonNls
    public static final String MAIN_LOG_ID = "MAIN";
    private static final int RECENTLY_FILTERED_VALUES_LIMIT = 10;
    @NotNull
    private final VcsLogApplicationSettings myAppSettings;
    @NotNull
    private State myState = new State();

    public VcsLogProjectTabsProperties() {
        this.myAppSettings = (VcsLogApplicationSettings)ApplicationManager.getApplication().getService(VcsLogApplicationSettings.class);
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        for (String tab : this.myState.OPEN_TABS) {
            this.myState.OPEN_GENERIC_TABS.put(tab, VcsLogManager.LogWindowKind.TOOL_WINDOW);
        }
        this.myState.OPEN_TABS.clear();
        if (!this.myState.oldMeFiltersMigrated) {
            FilterConfigMigrationUtil.migrateRecentUserFilters(this.myState.RECENT_FILTERS);
            this.myState.TAB_STATES.values().forEach(tabState -> FilterConfigMigrationUtil.migrateTabUserFilters(tabState.FILTERS));
            this.myState.oldMeFiltersMigrated = true;
        }
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties createProperties(@NotNull String id) {
        this.myState.TAB_STATES.putIfAbsent(id, new MyState());
        return new MyVcsLogUiPropertiesImpl(id);
    }

    public void addTab(@NotNull String tabId, @NotNull VcsLogManager.LogWindowKind kind) {
        this.myState.OPEN_GENERIC_TABS.put(tabId, kind);
    }

    public void removeTab(@NotNull String tabId) {
        this.myState.OPEN_GENERIC_TABS.remove(tabId);
    }

    public void resetState(@NotNull String tabId) {
        this.myState.TAB_STATES.put(tabId, null);
    }

    @NotNull
    public Map<String, VcsLogManager.LogWindowKind> getTabs() {
        return this.myState.OPEN_GENERIC_TABS;
    }

    public static void addRecentGroup(@NotNull Map<String, List<RecentGroup>> stateField, @NotNull String filterName, @NotNull Collection<String> values) {
        List<RecentGroup> recentGroups = stateField.get(filterName);
        if (recentGroups == null) {
            recentGroups = new ArrayList<RecentGroup>();
            stateField.put(filterName, recentGroups);
        }
        RecentGroup group = new RecentGroup(values);
        recentGroups.remove(group);
        recentGroups.add(0, group);
        while (recentGroups.size() > 10) {
            recentGroups.remove(recentGroups.size() - 1);
        }
    }

    @NotNull
    public static List<List<String>> getRecentGroup(@NotNull Map<String, List<RecentGroup>> stateField, @NotNull String filterName) {
        List<RecentGroup> values = stateField.get(filterName);
        if (values == null) {
            return ContainerUtil.emptyList();
        }
        return ContainerUtil.map2List(values, group -> group.FILTER_VALUES);
    }

    public static class CustomBooleanTabProperty
    extends VcsLogUiProperties.VcsLogUiProperty<Boolean> {
        public CustomBooleanTabProperty(@NotNull @NonNls String name) {
            super(name);
        }

        @NotNull
        public Boolean defaultValue(@NotNull String logId) {
            return Boolean.FALSE;
        }
    }

    @Tag(value="State")
    private static class MyState
    extends VcsLogUiPropertiesImpl.State {
        public Map<String, Boolean> CUSTOM_BOOLEAN_PROPERTIES = new HashMap<String, Boolean>();

        private MyState() {
        }
    }

    private class MyVcsLogUiPropertiesImpl
    extends VcsLogUiPropertiesImpl<MyState> {
        private final String myId;

        MyVcsLogUiPropertiesImpl(String id) {
            super(VcsLogProjectTabsProperties.this.myAppSettings);
            this.myId = id;
        }

        @Override
        @NotNull
        public MyState getState() {
            MyState state = ((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.TAB_STATES.get(this.myId);
            if (state == null) {
                state = new MyState();
                ((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.TAB_STATES.put(this.myId, state);
            }
            return state;
        }

        public void loadState(@NotNull MyState state) {
            ((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.TAB_STATES.put(this.myId, state);
        }

        @Override
        @NotNull
        public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property instanceof CustomBooleanTabProperty) {
                Boolean value = this.getState().CUSTOM_BOOLEAN_PROPERTIES.get(property.getName());
                if (value == null) {
                    value = ((CustomBooleanTabProperty)property).defaultValue(this.myId);
                }
                return (T)value;
            }
            return super.get(property);
        }

        @Override
        public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, @NotNull T value) {
            if (property instanceof CustomBooleanTabProperty) {
                this.getState().CUSTOM_BOOLEAN_PROPERTIES.put(property.getName(), (Boolean)value);
                this.onPropertyChanged(property);
                return;
            }
            super.set(property, value);
        }

        @Override
        public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            return super.exists(property) || property instanceof CustomBooleanTabProperty;
        }

        @Override
        public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values) {
            VcsLogProjectTabsProperties.addRecentGroup(((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.RECENT_FILTERS, filterName, values);
        }

        @Override
        @NotNull
        public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
            return VcsLogProjectTabsProperties.getRecentGroup(((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.RECENT_FILTERS, filterName);
        }
    }

    public static class RecentGroup {
        @XCollection
        public List<String> FILTER_VALUES = new ArrayList<String>();

        public RecentGroup() {
        }

        public RecentGroup(@NotNull Collection<String> values) {
            this.FILTER_VALUES.addAll(values);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecentGroup group = (RecentGroup)o;
            return Comparing.haveEqualElements(this.FILTER_VALUES, group.FILTER_VALUES);
        }

        public int hashCode() {
            return Comparing.unorderedHashcode(this.FILTER_VALUES);
        }
    }

    public static class State {
        public Map<String, MyState> TAB_STATES = new TreeMap<String, MyState>();
        @Deprecated
        public LinkedHashSet<String> OPEN_TABS = new LinkedHashSet();
        public LinkedHashMap<String, VcsLogManager.LogWindowKind> OPEN_GENERIC_TABS = new LinkedHashMap();
        public Map<String, List<RecentGroup>> RECENT_FILTERS = new HashMap<String, List<RecentGroup>>();
        public boolean oldMeFiltersMigrated = false;
    }
}

