/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class CommonUiProperties {
    public static final VcsLogUiProperties.VcsLogUiProperty<Boolean> SHOW_DETAILS = new VcsLogUiProperties.VcsLogUiProperty("Window.ShowDetails");
    public static final VcsLogUiProperties.VcsLogUiProperty<Boolean> SHOW_DIFF_PREVIEW = new VcsLogUiProperties.VcsLogUiProperty("Window.ShowDiffPreview");
    public static final Map<VcsLogColumn, VcsLogUiProperties.VcsLogUiProperty<Integer>> COLUMN_WIDTH = new HashMap<VcsLogColumn, VcsLogUiProperties.VcsLogUiProperty<Integer>>();
    public static final VcsLogUiProperties.VcsLogUiProperty<List<Integer>> COLUMN_ORDER = new VcsLogUiProperties.VcsLogUiProperty("Table.ColumnOrder");
    public static final VcsLogUiProperties.VcsLogUiProperty<Boolean> SHOW_ROOT_NAMES = new VcsLogUiProperties.VcsLogUiProperty("Table.ShowRootNames");
    public static final VcsLogUiProperties.VcsLogUiProperty<Boolean> PREFER_COMMIT_DATE = new VcsLogUiProperties.VcsLogUiProperty("Table.PreferCommitDate");

    public static void saveColumnWidth(@NotNull VcsLogUiProperties properties, @NotNull VcsLogColumn column, int width) {
        VcsLogUiProperties.VcsLogUiProperty<Integer> property = COLUMN_WIDTH.get((Object)column);
        if (properties.exists(property) && properties.get(property) != width) {
            properties.set(property, width);
        }
    }

    public static int getColumnWidth(@NotNull VcsLogUiProperties properties, @NotNull VcsLogColumn column) {
        VcsLogUiProperties.VcsLogUiProperty<Integer> property = COLUMN_WIDTH.get((Object)column);
        if (properties.exists(property)) {
            return properties.get(property);
        }
        return -1;
    }

    static {
        for (VcsLogColumn column : VcsLogColumn.DYNAMIC_COLUMNS) {
            COLUMN_WIDTH.put(column, new TableColumnProperty(column));
        }
    }

    public static class TableColumnProperty
    extends VcsLogUiProperties.VcsLogUiProperty<Integer> {
        private final VcsLogColumn myColumn;

        public TableColumnProperty(@NotNull VcsLogColumn column) {
            super("Table." + column.getName() + "ColumnWidth");
            this.myColumn = column;
        }

        public int getColumnIndex() {
            return this.myColumn.ordinal();
        }

        public VcsLogColumn getColumn() {
            return this.myColumn;
        }
    }
}

