/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUiFactory
implements VcsLogManager.VcsLogUiFactory<FileHistoryUi> {
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private final Hash myHash;

    public FileHistoryUiFactory(@NotNull FilePath path2, @NotNull VirtualFile root, @Nullable Hash hash) {
        this.myFilePath = path2;
        this.myRoot = root;
        this.myHash = hash;
    }

    @Override
    public FileHistoryUi createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
        FileHistoryUiProperties properties = (FileHistoryUiProperties)ServiceManager.getService((Project)project, FileHistoryUiProperties.class);
        VcsLogFilterCollection filters = FileHistoryFilterer.createFilters(this.myFilePath, this.myHash, this.myRoot, properties.get(FileHistoryUiProperties.SHOW_ALL_BRANCHES));
        return new FileHistoryUi(logData, properties, new VisiblePackRefresherImpl(project, logData, filters, PermanentGraph.SortType.Normal, new FileHistoryFilterer(logData), FileHistoryUi.getFileHistoryLogId(this.myFilePath, this.myHash)), this.myFilePath, this.myHash, this.myRoot);
    }
}

