/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ValueKey;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryDiffProcessor;
import com.intellij.vcs.log.history.FileHistoryModel;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.frame.FrameDiffPreview;
import com.intellij.vcs.log.ui.frame.VcsLogCommitDetailsListPanel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryPanel
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final FileHistoryModel myFileHistoryModel;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final VcsLogCommitDetailsListPanel myDetailsPanel;
    @NotNull
    private final JBSplitter myDetailsSplitter;

    public FileHistoryPanel(final @NotNull AbstractVcsLogUi logUi, @NotNull FileHistoryModel fileHistoryModel, @NotNull VcsLogData logData, @NotNull FilePath filePath, boolean withDiffPreview, @NotNull Disposable disposable) {
        this.myProject = logData.getProject();
        this.myFilePath = filePath;
        this.myRoot = Objects.requireNonNull(VcsLogUtil.getActualRoot(this.myProject, this.myFilePath));
        this.myFileHistoryModel = fileHistoryModel;
        this.myProperties = logUi.getProperties();
        this.myGraphTable = new VcsLogGraphTable(logUi.getId(), logData, logUi.getProperties(), logUi.getColorManager(), logUi::requestMore, disposable){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return true;
            }

            @Override
            protected void updateEmptyText() {
                VisiblePack visiblePack = this.getModel().getVisiblePack();
                if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
                    this.setErrorEmptyText(((VisiblePack.ErrorVisiblePack)visiblePack).getError(), VcsLogBundle.message((String)"file.history.error.status", (Object[])new Object[0]));
                    this.appendActionToEmptyText(VcsLogBundle.message((String)"vcs.log.refresh.status.action", (Object[])new Object[0]), () -> logUi.getRefresher().onRefresh());
                } else {
                    this.getEmptyText().setText(VcsLogBundle.message((String)"file.history.empty.status", (Object[])new Object[0]));
                }
            }
        };
        this.myGraphTable.setCompactReferencesView(true);
        this.myGraphTable.setShowTagNames(false);
        this.myGraphTable.setLabelsLeftAligned(false);
        this.myGraphTable.setBorder(this.myGraphTable.createTopBottomBorder(1, 0));
        this.myDetailsPanel = new VcsLogCommitDetailsListPanel(logData, new VcsLogColorManagerImpl(Collections.singleton(this.myRoot)), this){

            @Override
            protected void navigate(@NotNull CommitId commit) {
                VcsLogContentUtil.runInMainLog(FileHistoryPanel.this.myProject, (Consumer<? super MainVcsLogUi>)((Consumer)ui2 -> ui2.jumpToCommit(commit.getHash(), commit.getRoot())));
            }
        };
        this.myDetailsPanel.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myDetailsSplitter = new OnePixelSplitter(true, "vcs.log.history.details.splitter.proportion", 0.7f);
        JComponent tableWithProgress = VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 1), logData, logUi.getId(), this);
        this.myDetailsSplitter.setFirstComponent(tableWithProgress);
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(this.myProperties.get(CommonUiProperties.SHOW_DETAILS) != false ? this.myDetailsPanel : null)));
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, logData, this);
        JBPanel tablePanel = new JBPanel((LayoutManager)new BorderLayout());
        tablePanel.add((Component)this.myDetailsSplitter, (Object)"Center");
        tablePanel.add((Component)this.createActionsToolbar(), (Object)"West");
        this.setLayout(new BorderLayout());
        if (withDiffPreview) {
            this.add((Component)new FrameDiffPreview<FileHistoryDiffProcessor>(this.createDiffPreview(false), this.myProperties, (JComponent)tablePanel, "vcs.history.diff.splitter.proportion", false, 0.7f){

                @Override
                public void updatePreview(boolean state) {
                    ((FileHistoryDiffProcessor)this.getPreviewDiff()).updatePreview(state);
                }
            }.getMainComponent(), "Center");
        } else {
            this.add((Component)tablePanel, "Center");
        }
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.FileHistory.ContextMenu", (String)"Vcs.FileHistory.ContextMenu");
        this.invokeOnDoubleClick(ActionManager.getInstance().getAction("Diff.ShowDiff"), tableWithProgress);
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    private void invokeOnDoubleClick(@NotNull AnAction action, @NotNull JComponent component) {
        new EmptyAction.MyDelegatingAction(action){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e.getInputEvent() instanceof MouseEvent && FileHistoryPanel.this.myGraphTable.isResizingColumns()) {
                    return;
                }
                super.actionPerformed(e);
            }
        }.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, component);
    }

    @NotNull
    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.FileHistory.Toolbar"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Vcs.FileHistory.Toolbar", (ActionGroup)toolbarGroup, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myGraphTable));
        return toolbar.getComponent();
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        return this.myGraphTable;
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permanentGraphChanged) {
        this.myGraphTable.updateDataPack(visiblePack, permanentGraphChanged);
    }

    public void showDetails(boolean show) {
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(show ? this.myDetailsPanel : null)));
    }

    @NotNull
    FileHistoryDiffProcessor createDiffPreview(boolean isInEditor) {
        FileHistoryDiffProcessor diffPreview = new FileHistoryDiffProcessor(this.myProject, (Function0<? extends Change>)((Function0)() -> this.getSelectedChange()), isInEditor, this);
        ListSelectionListener selectionListener2 = e -> {
            int[] selection = this.myGraphTable.getSelectedRows();
            ApplicationManager.getApplication().invokeLater(() -> diffPreview.updatePreview(diffPreview.getComponent().isShowing()), o -> !Arrays.equals(selection, this.myGraphTable.getSelectedRows()) || Disposer.isDisposed((Disposable)diffPreview));
        };
        this.myGraphTable.getSelectionModel().addListSelectionListener(selectionListener2);
        Disposer.register((Disposable)diffPreview, () -> this.myGraphTable.getSelectionModel().removeListSelectionListener(selectionListener2));
        TableModelListener modelListener = e -> {
            if (e.getColumn() < 0) {
                ApplicationManager.getApplication().invokeLater(() -> diffPreview.updatePreview(diffPreview.getComponent().isShowing()), o -> Disposer.isDisposed((Disposable)diffPreview));
            }
        };
        this.myGraphTable.getModel().addTableModelListener(modelListener);
        Disposer.register((Disposable)diffPreview, () -> this.myGraphTable.getModel().removeTableModelListener(modelListener));
        return diffPreview;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        return ValueKey.match((String)dataId).ifEq((ValueKey)VcsDataKeys.CHANGES).or((ValueKey)VcsDataKeys.SELECTED_CHANGES).thenGet(() -> {
            Change change = this.getSelectedChange();
            if (change != null) {
                return new Change[]{change};
            }
            return null;
        }).ifEq(VcsLogInternalDataKeys.LOG_UI_PROPERTIES).then((Object)this.myProperties).ifEq((ValueKey)VcsDataKeys.VCS_FILE_REVISION).thenGet(() -> {
            List<VcsCommitMetadata> details = this.getSelectedMetadata();
            if (details.isEmpty()) {
                return null;
            }
            return this.myFileHistoryModel.createRevision((VcsCommitMetadata)ContainerUtil.getFirstItem(details));
        }).ifEq((ValueKey)VcsDataKeys.VCS_FILE_REVISIONS).thenGet(() -> {
            List<VcsCommitMetadata> details = this.getSelectedMetadata();
            if (details.isEmpty() || details.size() > 1000) {
                return null;
            }
            return ContainerUtil.mapNotNull(details, this.myFileHistoryModel::createRevision).toArray(new VcsFileRevision[0]);
        }).ifEq((ValueKey)VcsDataKeys.FILE_PATH).then((Object)this.myFilePath).ifEq((ValueKey)VcsDataKeys.VCS_VIRTUAL_FILE).thenGet(() -> {
            List<VcsCommitMetadata> details = this.getSelectedMetadata();
            if (details.isEmpty()) {
                return null;
            }
            VcsCommitMetadata detail = (VcsCommitMetadata)Objects.requireNonNull(ContainerUtil.getFirstItem(details));
            return FileHistoryUtil.createVcsVirtualFile(this.myFileHistoryModel.createRevision(detail));
        }).ifEq((ValueKey)CommonDataKeys.VIRTUAL_FILE).thenGet(() -> ((FilePath)this.myFilePath).getVirtualFile()).ifEq((ValueKey)VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION).then((Object)false).ifEq(VcsLogInternalDataKeys.LOG_DIFF_HANDLER).thenGet(() -> this.myFileHistoryModel.getDiffHandler()).orNull();
    }

    @Nullable
    private Change getSelectedChange() {
        return this.myFileHistoryModel.getSelectedChange(this.myGraphTable.getSelectedRows());
    }

    @NotNull
    private List<VcsCommitMetadata> getSelectedMetadata() {
        return this.myGraphTable.getModel().getCommitMetadata(this.myGraphTable.getSelectedRows());
    }

    @NotNull
    FilePath getFilePath() {
        return this.myFilePath;
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
    }
}

