/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PermanentCommitsInfoImpl<CommitId>
implements PermanentCommitsInfo<CommitId> {
    private static final Logger LOG = Logger.getInstance(PermanentCommitsInfoImpl.class);
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final List<? extends CommitId> myCommitIdIndexes;
    @NotNull
    private final Int2ObjectOpenHashMap<CommitId> myNotLoadCommits;

    @NotNull
    public static <CommitId> PermanentCommitsInfoImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull Int2ObjectOpenHashMap<CommitId> notLoadedCommits) {
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        boolean isIntegerCase = !graphCommits.isEmpty() && graphCommits.get(0).getId().getClass() == Integer.class;
        List commitIdIndex = isIntegerCase ? PermanentCommitsInfoImpl.createCompressedIntList(graphCommits) : ContainerUtil.map(graphCommits, GraphCommit::getId);
        return new PermanentCommitsInfoImpl<CommitId>(timestampGetter, commitIdIndex, notLoadedCommits);
    }

    @NotNull
    public static <CommitId> IntTimestampGetter createTimestampGetter(final @NotNull List<? extends GraphCommit<CommitId>> graphCommits) {
        return IntTimestampGetter.newInstance(new TimestampGetter(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public long getTimestamp(int index) {
                return ((GraphCommit)graphCommits.get(index)).getTimestamp();
            }
        });
    }

    @NotNull
    private static List<Integer> createCompressedIntList(final @NotNull List<? extends GraphCommit<Integer>> graphCommits) {
        final IntList compressedIntList = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public int get(int index) {
                return (Integer)((GraphCommit)graphCommits.get(index)).getId();
            }
        }, 30);
        return new AbstractList<Integer>(){

            @Override
            @NotNull
            public Integer get(int index) {
                return compressedIntList.get(index);
            }

            @Override
            public int size() {
                return compressedIntList.size();
            }
        };
    }

    private PermanentCommitsInfoImpl(@NotNull TimestampGetter timestampGetter, @NotNull List<? extends CommitId> commitIdIndex, @NotNull Int2ObjectOpenHashMap<CommitId> notLoadCommits) {
        this.myTimestampGetter = timestampGetter;
        this.myCommitIdIndexes = commitIdIndex;
        this.myNotLoadCommits = notLoadCommits;
    }

    @Override
    @NotNull
    public CommitId getCommitId(int nodeId) {
        if (nodeId < 0) {
            return (CommitId)this.myNotLoadCommits.get(nodeId);
        }
        return this.myCommitIdIndexes.get(nodeId);
    }

    @Override
    public long getTimestamp(int nodeId) {
        if (nodeId < 0) {
            return 0L;
        }
        return this.myTimestampGetter.getTimestamp(nodeId);
    }

    @NotNull
    public TimestampGetter getTimestampGetter() {
        return this.myTimestampGetter;
    }

    @Override
    public int getNodeId(@NotNull CommitId commitId) {
        int indexOf = this.myCommitIdIndexes.indexOf(commitId);
        if (indexOf != -1) {
            return indexOf;
        }
        return this.getNotLoadNodeId(commitId);
    }

    private int getNotLoadNodeId(@NotNull CommitId commitId) {
        ObjectIterator iterator = this.myNotLoadCommits.int2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            if (!entry.getValue().equals(commitId)) continue;
            return entry.getIntKey();
        }
        return -1;
    }

    @NotNull
    public List<CommitId> convertToCommitIdList(@NotNull Collection<Integer> commitIndexes) {
        return ContainerUtil.map(commitIndexes, this::getCommitId);
    }

    @NotNull
    public Set<CommitId> convertToCommitIdSet(@NotNull Collection<Integer> commitIndexes) {
        return ContainerUtil.map2Set(commitIndexes, this::getCommitId);
    }

    @Override
    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<? extends CommitId> commitIds) {
        return this.convertToNodeIds(commitIds, false);
    }

    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<? extends CommitId> commitIds, boolean reportNotFound) {
        Collection unmatchedIds;
        HashSet<Integer> result2 = new HashSet<Integer>();
        HashSet<CommitId> matchedIds = new HashSet<CommitId>();
        for (int i = 0; i < this.myCommitIdIndexes.size(); ++i) {
            CommitId commitId = this.myCommitIdIndexes.get(i);
            if (!commitIds.contains(commitId)) continue;
            result2.add(i);
            matchedIds.add(commitId);
        }
        if (reportNotFound && !(unmatchedIds = ContainerUtil.subtract(commitIds, matchedIds)).isEmpty()) {
            LOG.warn("Unmatched commit ids " + unmatchedIds);
        }
        ObjectIterator iterator = this.myNotLoadCommits.int2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            Object value = entry.getValue();
            if (!commitIds.contains(value)) continue;
            result2.add(entry.getIntKey());
        }
        return result2;
    }

    public boolean containsAll(@NotNull Collection<? extends CommitId> commitIds) {
        HashSet<CommitId> commitsToFind = new HashSet<CommitId>(commitIds);
        for (CommitId commitId : this.myCommitIdIndexes) {
            commitsToFind.remove(commitId);
            if (!commitsToFind.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

