/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.vcs.log.graph.GraphCommit;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DuplicateParentFixer {
    public static <CommitId> AbstractList<? extends GraphCommit<CommitId>> fixDuplicateParentCommits(final List<? extends GraphCommit<CommitId>> finalCommits) {
        return new AbstractList<GraphCommit<CommitId>>(){

            @Override
            public GraphCommit<CommitId> get(int index) {
                return DuplicateParentFixer.fixParentsDuplicate((GraphCommit)finalCommits.get(index));
            }

            @Override
            public int size() {
                return finalCommits.size();
            }
        };
    }

    @NotNull
    private static <CommitId> GraphCommit<CommitId> fixParentsDuplicate(@NotNull GraphCommit<CommitId> commit) {
        List parents = commit.getParents();
        if (parents.size() <= 1) {
            return commit;
        }
        if (parents.size() == 2) {
            Object commitId0 = parents.get(0);
            if (!commitId0.equals(parents.get(1))) {
                return commit;
            }
            return new DelegateGraphCommit(commit, Collections.singletonList(commitId0));
        }
        HashSet allParents = new HashSet(parents);
        if (parents.size() == allParents.size()) {
            return commit;
        }
        ArrayList correctParents = new ArrayList();
        for (Object commitId : parents) {
            if (!allParents.remove(commitId)) continue;
            correctParents.add(commitId);
        }
        return new DelegateGraphCommit(commit, correctParents);
    }

    private static class DelegateGraphCommit<CommitId>
    implements GraphCommit<CommitId> {
        @NotNull
        private final GraphCommit<CommitId> myDelegate;
        @NotNull
        private final List<CommitId> myParents;

        private DelegateGraphCommit(@NotNull GraphCommit<CommitId> delegate, @NotNull List<CommitId> parents) {
            this.myDelegate = delegate;
            this.myParents = parents;
        }

        @NotNull
        public CommitId getId() {
            return (CommitId)this.myDelegate.getId();
        }

        @NotNull
        public List<CommitId> getParents() {
            return this.myParents;
        }

        public long getTimestamp() {
            return this.myDelegate.getTimestamp();
        }
    }
}

