/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BekBranch {
    private static final int MAX_BLOCK_SIZE = 20;
    private static final int MAX_DELTA_TIME = 259200000;
    private static final int SMALL_DELTA_TIME = 14400000;
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final List<Integer> myNodeIndexes;
    private int myNoInsertSize;
    @Nullable
    private List<Integer> myPrepareForInsertPart = null;

    BekBranch(@NotNull LinearGraph permanentGraph, @NotNull List<Integer> nodeIndexes) {
        this.myPermanentGraph = permanentGraph;
        this.myNodeIndexes = nodeIndexes;
        this.myNoInsertSize = this.myNodeIndexes.size();
    }

    public void updatePrepareForInsertPart(@NotNull TimestampGetter timestampGetter, @NotNull BekEdgeRestrictions edgeRestrictions) {
        int prevIndex;
        assert (this.myPrepareForInsertPart == null);
        int currentNode = this.myNodeIndexes.get(this.myNoInsertSize - 1);
        if (edgeRestrictions.hasRestriction(currentNode)) {
            return;
        }
        for (prevIndex = this.myNoInsertSize - 1; prevIndex > 0; --prevIndex) {
            long delta;
            List<Integer> downNodes;
            int upNode = this.myNodeIndexes.get(prevIndex - 1);
            int downNode = this.myNodeIndexes.get(prevIndex);
            if (edgeRestrictions.hasRestriction(upNode) || ((downNodes = LinearGraphUtils.getDownNodes(this.myPermanentGraph, upNode)).size() <= 1 || !downNodes.contains(downNode)) && (!downNodes.contains(downNode) || (delta = Math.abs(timestampGetter.getTimestamp(upNode) - timestampGetter.getTimestamp(downNode))) > 259200000L || prevIndex < this.myNoInsertSize - 20 && delta > 14400000L)) break;
        }
        this.myPrepareForInsertPart = this.myNodeIndexes.subList(prevIndex, this.myNoInsertSize);
    }

    @Nullable
    public List<Integer> getPrepareForInsertPart() {
        return this.myPrepareForInsertPart;
    }

    public void doneInsertPreparedPart() {
        assert (this.myPrepareForInsertPart != null);
        this.myNoInsertSize -= this.myPrepareForInsertPart.size();
        this.myPrepareForInsertPart = null;
    }

    public boolean isDone() {
        return this.myNoInsertSize == 0;
    }
}

