/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNodeType;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.PrintElementManagerImpl;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibleGraphImpl<CommitId>
implements VisibleGraph<CommitId> {
    @NotNull
    private final LinearGraphController myGraphController;
    @NotNull
    private final PermanentGraphInfo<CommitId> myPermanentGraph;
    @NotNull
    private final GraphColorManager<CommitId> myColorManager;
    private PrintElementManagerImpl myPrintElementManager;
    private PrintElementGeneratorImpl myPrintElementGenerator;
    private boolean myShowLongEdges = false;

    public VisibleGraphImpl(@NotNull LinearGraphController graphController, @NotNull PermanentGraphInfo<CommitId> permanentGraph, @NotNull GraphColorManager<CommitId> colorManager) {
        this.myGraphController = graphController;
        this.myPermanentGraph = permanentGraph;
        this.myColorManager = colorManager;
        this.updatePrintElementGenerator();
    }

    public int getVisibleCommitCount() {
        return this.myGraphController.getCompiledGraph().nodesCount();
    }

    @NotNull
    public RowInfo<CommitId> getRowInfo(int visibleRow) {
        int nodeId = this.getNodeId(visibleRow);
        assert (nodeId >= 0);
        return new RowInfoImpl(nodeId, visibleRow);
    }

    public int getNodeId(int visibleRow) {
        return this.myGraphController.getCompiledGraph().getNodeId(visibleRow);
    }

    @Nullable
    public Integer getVisibleRowIndex(@NotNull CommitId commitId) {
        int nodeId = this.myPermanentGraph.getPermanentCommitsInfo().getNodeId(commitId);
        return this.myGraphController.getCompiledGraph().getNodeIndex(nodeId);
    }

    @NotNull
    public ActionController<CommitId> getActionController() {
        return new ActionControllerImpl();
    }

    void updatePrintElementGenerator() {
        this.myPrintElementManager = new PrintElementManagerImpl(this.myGraphController.getCompiledGraph(), this.myPermanentGraph, this.myColorManager);
        this.myPrintElementGenerator = new PrintElementGeneratorImpl(this.myGraphController.getCompiledGraph(), this.myPrintElementManager, this.myShowLongEdges);
    }

    @NotNull
    public SimpleGraphInfo<CommitId> buildSimpleGraphInfo(int visibleRow, int visibleRange) {
        return SimpleGraphInfo.build(this.myGraphController.getCompiledGraph(), this.myPermanentGraph.getPermanentGraphLayout(), this.myPermanentGraph.getPermanentCommitsInfo(), this.myPermanentGraph.getLinearGraph().nodesCount(), this.myPermanentGraph.getBranchNodeIds(), visibleRow, visibleRange);
    }

    public int getRecommendedWidth() {
        return this.myPrintElementGenerator.getRecommendedWidth();
    }

    public LinearGraph getLinearGraph() {
        return this.myGraphController.getCompiledGraph();
    }

    @NotNull
    public PermanentGraphInfo<CommitId> getPermanentGraph() {
        return this.myPermanentGraph;
    }

    public String toString() {
        ArrayList<Object> commits = new ArrayList<Object>();
        for (int i = 0; i < this.getVisibleCommitCount(); ++i) {
            commits.add(this.getRowInfo(i).getCommit());
        }
        return "VisibleGraph[" + StringUtil.join(commits, (String)", ") + "]";
    }

    private class RowInfoImpl
    implements RowInfo<CommitId> {
        private final int myNodeId;
        private final int myVisibleRow;

        RowInfoImpl(int nodeId, int visibleRow) {
            this.myNodeId = nodeId;
            this.myVisibleRow = visibleRow;
        }

        @NotNull
        public CommitId getCommit() {
            return VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(this.myNodeId);
        }

        @NotNull
        public CommitId getOneOfHeads() {
            int headNodeId = VisibleGraphImpl.this.myPermanentGraph.getPermanentGraphLayout().getOneOfHeadNodeIndex(this.myNodeId);
            return VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(headNodeId);
        }

        @NotNull
        public Collection<? extends PrintElement> getPrintElements() {
            return VisibleGraphImpl.this.myPrintElementGenerator.getPrintElements(this.myVisibleRow);
        }

        @NotNull
        public RowType getRowType() {
            GraphNodeType nodeType = VisibleGraphImpl.this.myGraphController.getCompiledGraph().getGraphNode(this.myVisibleRow).getType();
            switch (nodeType) {
                case USUAL: {
                    return RowType.NORMAL;
                }
                case UNMATCHED: {
                    return RowType.UNMATCHED;
                }
            }
            throw new UnsupportedOperationException("Unsupported node type: " + (Object)((Object)nodeType));
        }

        @NotNull
        public List<Integer> getAdjacentRows(boolean parent) {
            return parent ? LinearGraphUtils.getDownNodes(VisibleGraphImpl.this.myGraphController.getCompiledGraph(), this.myVisibleRow) : LinearGraphUtils.getUpNodes(VisibleGraphImpl.this.myGraphController.getCompiledGraph(), this.myVisibleRow);
        }
    }

    public static class LinearGraphActionImpl
    implements LinearGraphController.LinearGraphAction {
        @Nullable
        private final PrintElementWithGraphElement myAffectedElement;
        @NotNull
        private final GraphAction.Type myType;

        public LinearGraphActionImpl(@Nullable PrintElementWithGraphElement affectedElement, @NotNull GraphAction.Type type) {
            this.myAffectedElement = affectedElement;
            this.myType = type;
        }

        @Override
        @Nullable
        public PrintElementWithGraphElement getAffectedElement() {
            return this.myAffectedElement;
        }

        @NotNull
        public GraphAction.Type getType() {
            return this.myType;
        }
    }

    private static class GraphAnswerImpl<CommitId>
    implements GraphAnswer<CommitId> {
        @Nullable
        private final Cursor myCursor;
        @Nullable
        private final CommitId myCommitToJump;
        @Nullable
        private final Runnable myUpdater;
        private final boolean myDoJump;
        private final boolean myIsRepaintRequired;

        private GraphAnswerImpl(@Nullable Cursor cursor, @Nullable CommitId commitToJump, @Nullable Runnable updater, boolean doJump, boolean isRepaintRequired) {
            this.myCursor = cursor;
            this.myCommitToJump = commitToJump;
            this.myUpdater = updater;
            this.myDoJump = doJump;
            this.myIsRepaintRequired = isRepaintRequired;
        }

        @Nullable
        public Cursor getCursorToSet() {
            return this.myCursor;
        }

        @Nullable
        public CommitId getCommitToJump() {
            return this.myCommitToJump;
        }

        @Nullable
        public Runnable getGraphUpdater() {
            return this.myUpdater;
        }

        public boolean doJump() {
            return this.myDoJump;
        }

        public boolean isRepaintRequired() {
            return this.myIsRepaintRequired;
        }
    }

    private class ActionControllerImpl
    implements ActionController<CommitId> {
        private ActionControllerImpl() {
        }

        @Nullable
        private Integer convertToNodeId(@Nullable Integer nodeIndex) {
            if (nodeIndex == null) {
                return null;
            }
            return VisibleGraphImpl.this.getNodeId(nodeIndex);
        }

        @Nullable
        private GraphAnswer<CommitId> performArrowAction(@NotNull LinearGraphController.LinearGraphAction action) {
            PrintElementWithGraphElement affectedElement = action.getAffectedElement();
            if (!(affectedElement instanceof EdgePrintElement)) {
                return null;
            }
            EdgePrintElement edgePrintElement = (EdgePrintElement)affectedElement;
            if (!edgePrintElement.hasArrow()) {
                return null;
            }
            GraphElement graphElement = affectedElement.getGraphElement();
            if (!(graphElement instanceof GraphEdge)) {
                return null;
            }
            GraphEdge edge = (GraphEdge)graphElement;
            Integer targetId = null;
            if (edge.getType() == GraphEdgeType.NOT_LOAD_COMMIT) {
                assert (edgePrintElement.getType().equals((Object)EdgePrintElement.Type.DOWN));
                targetId = edge.getTargetId();
            }
            if (edge.getType().isNormalEdge()) {
                targetId = edgePrintElement.getType().equals((Object)EdgePrintElement.Type.DOWN) ? this.convertToNodeId(edge.getDownNodeIndex()) : this.convertToNodeId(edge.getUpNodeIndex());
            }
            if (targetId == null) {
                return null;
            }
            if (action.getType() == GraphAction.Type.MOUSE_OVER) {
                boolean selectionChanged = VisibleGraphImpl.this.myPrintElementManager.setSelectedElement(affectedElement);
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(true), VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(targetId), null, false, selectionChanged);
            }
            if (action.getType() == GraphAction.Type.MOUSE_CLICK) {
                boolean selectionChanged = VisibleGraphImpl.this.myPrintElementManager.setSelectedElements(Collections.emptySet());
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(false), VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(targetId), null, true, selectionChanged);
            }
            return null;
        }

        @NotNull
        public GraphAnswer<CommitId> performAction(@NotNull GraphAction graphAction) {
            LinearGraphController.LinearGraphAction action = this.convert(graphAction);
            GraphAnswer graphAnswer = this.performArrowAction(action);
            if (graphAnswer != null) {
                return graphAnswer;
            }
            LinearGraphController.LinearGraphAnswer answer = VisibleGraphImpl.this.myGraphController.performLinearGraphAction(action);
            boolean selectionChanged = answer.getSelectedNodeIds() != null ? VisibleGraphImpl.this.myPrintElementManager.setSelectedElements(answer.getSelectedNodeIds()) : VisibleGraphImpl.this.myPrintElementManager.setSelectedElements(Collections.emptySet());
            if (answer.getGraphChanges() != null) {
                VisibleGraphImpl.this.updatePrintElementGenerator();
            }
            return this.convert(answer, selectionChanged);
        }

        public boolean areLongEdgesHidden() {
            return !VisibleGraphImpl.this.myShowLongEdges;
        }

        public void setLongEdgesHidden(boolean longEdgesHidden) {
            VisibleGraphImpl.this.myShowLongEdges = !longEdgesHidden;
            VisibleGraphImpl.this.updatePrintElementGenerator();
        }

        @NotNull
        private LinearGraphController.LinearGraphAction convert(@NotNull GraphAction graphAction) {
            PrintElementWithGraphElement printElement = null;
            PrintElement affectedElement = graphAction.getAffectedElement();
            if (affectedElement != null) {
                if (affectedElement instanceof PrintElementWithGraphElement) {
                    printElement = (PrintElementWithGraphElement)affectedElement;
                } else {
                    printElement = (PrintElementWithGraphElement)ContainerUtil.find(VisibleGraphImpl.this.myPrintElementGenerator.getPrintElements(affectedElement.getRowIndex()), it -> it.equals(affectedElement));
                    if (printElement == null) {
                        throw new IllegalStateException("Not found graphElement for this printElement: " + affectedElement);
                    }
                }
            }
            return new LinearGraphActionImpl(printElement, graphAction.getType());
        }

        private GraphAnswer<CommitId> convert(@NotNull LinearGraphController.LinearGraphAnswer answer, boolean selectionChanged) {
            Runnable graphUpdater = answer.getGraphUpdater();
            return new GraphAnswerImpl(answer.getCursorToSet(), null, graphUpdater == null ? null : () -> {
                graphUpdater.run();
                VisibleGraphImpl.this.updatePrintElementGenerator();
            }, false, selectionChanged);
        }

        public boolean isActionSupported(@NotNull GraphAction action) {
            if (action.getType() == GraphAction.Type.BUTTON_COLLAPSE || action.getType() == GraphAction.Type.BUTTON_EXPAND) {
                return !(VisibleGraphImpl.this.myGraphController instanceof FilteredController);
            }
            return super.isActionSupported(action);
        }
    }
}

