/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.VcsDirectoryRenamesProvider;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.TroveUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntObjectHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexDataGetter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<? extends VirtualFile> myRoots;
    @NotNull
    private final VcsLogPersistentIndex.IndexStorage myIndexStorage;
    @NotNull
    private final VcsLogStorage myLogStorage;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsDirectoryRenamesProvider myDirectoryRenamesProvider;

    public IndexDataGetter(@NotNull Project project, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsLogPersistentIndex.IndexStorage indexStorage, @NotNull VcsLogStorage logStorage, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        this.myProject = project;
        this.myRoots = roots;
        this.myIndexStorage = indexStorage;
        this.myLogStorage = logStorage;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        this.myDirectoryRenamesProvider = VcsDirectoryRenamesProvider.getInstance(this.myProject);
    }

    @Nullable
    public VcsUser getAuthor(int commit) {
        return (VcsUser)this.executeAndCatch(() -> this.myIndexStorage.users.getAuthorForCommit(commit));
    }

    @Nullable
    public VcsUser getCommitter(int commit) {
        return (VcsUser)this.executeAndCatch(() -> {
            Integer committer = (Integer)this.myIndexStorage.committers.get((Object)commit);
            if (committer != null) {
                return this.myIndexStorage.users.getUserById(committer);
            }
            if (this.myIndexStorage.commits.contains(commit)) {
                return this.myIndexStorage.users.getAuthorForCommit(commit);
            }
            return null;
        });
    }

    @Nullable
    public Long getAuthorTime(int commit) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit);
            if (time == null) {
                return null;
            }
            return (Long)time.first;
        });
    }

    @Nullable
    public Long getCommitTime(int commit) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit);
            if (time == null) {
                return null;
            }
            return (Long)time.second;
        });
    }

    @Nullable
    public String getFullMessage(int index) {
        return (String)this.executeAndCatch(() -> (String)this.myIndexStorage.messages.get((Object)index));
    }

    @Nullable
    public List<Hash> getParents(int index) {
        return (List)this.executeAndCatch(() -> {
            List parentsIndexes = (List)this.myIndexStorage.parents.get((Object)index);
            if (parentsIndexes == null) {
                return null;
            }
            ArrayList<Hash> result2 = new ArrayList<Hash>();
            Iterator iterator = parentsIndexes.iterator();
            while (iterator.hasNext()) {
                int parentIndex = (Integer)iterator.next();
                CommitId id = this.myLogStorage.getCommitId(parentIndex);
                if (id == null) {
                    return null;
                }
                result2.add(id.getHash());
            }
            return result2;
        });
    }

    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters.isEmpty()) {
            return false;
        }
        return ContainerUtil.all(filters, filter -> {
            if (filter instanceof VcsLogTextFilter || filter instanceof VcsLogUserFilter) {
                return true;
            }
            if (filter instanceof VcsLogStructureFilter) {
                Collection files = ((VcsLogStructureFilter)filter).getFiles();
                return ContainerUtil.find((Iterable)files, file -> file.isDirectory() && this.myRoots.contains(file.getVirtualFile())) == null;
            }
            return false;
        });
    }

    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        return this.filter(detailsFilters, null);
    }

    @NotNull
    public IntSet filter(@NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable IntSet candidates) {
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        IntSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = new HashSet();
            for (VirtualFile virtualFile : this.myRoots) {
                users.addAll(userFilter.getUsers(virtualFile));
            }
            filteredByUser = this.filterUsers(users);
        }
        IntSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        IntSet filteredByUserAndPath = TroveUtil.intersect(filteredByUser, filteredByPath, candidates);
        if (textFilter == null) {
            return filteredByUserAndPath == null ? IntSets.EMPTY_SET : filteredByUserAndPath;
        }
        return this.filterMessages(textFilter, (IntIterable)filteredByUserAndPath);
    }

    @NotNull
    private IntSet filterUsers(@NotNull Set<? extends VcsUser> users) {
        return (IntSet)this.executeAndCatch(() -> this.myIndexStorage.users.getCommitsForUsers(users), new IntOpenHashSet());
    }

    @NotNull
    private IntSet filterPaths(@NotNull Collection<? extends FilePath> paths) {
        return (IntSet)this.executeAndCatch(() -> {
            IntOpenHashSet result2 = new IntOpenHashSet();
            for (FilePath path2 : paths) {
                IntSet commits = this.createFileHistoryData(path2).build().getCommits();
                if (commits.isEmpty() && !path2.isDirectory()) {
                    commits = this.createFileHistoryData(VcsUtil.getFilePath((String)path2.getPath(), (boolean)true)).build().getCommits();
                }
                result2.addAll((Collection)commits);
            }
            return result2;
        }, new IntOpenHashSet());
    }

    @NotNull
    private IntSet filterMessages(@NotNull VcsLogTextFilter filter, @Nullable IntIterable candidates) {
        IntSet resultByTrigrams;
        if ((!filter.isRegex() || filter instanceof VcsLogMultiplePatternsTextFilter) && (resultByTrigrams = (IntSet)this.executeAndCatch(() -> {
            List<String> trigramSources = filter instanceof VcsLogMultiplePatternsTextFilter ? ((VcsLogMultiplePatternsTextFilter)filter).getPatterns() : Collections.singletonList(filter.getText());
            IntOpenHashSet commitsForSearch = new IntOpenHashSet();
            for (String string : trigramSources) {
                IntSet commits = this.myIndexStorage.trigrams.getCommitsForSubstring(string);
                if (commits == null) {
                    return null;
                }
                if (candidates == null) {
                    commitsForSearch.addAll((IntCollection)commits);
                    continue;
                }
                IntIterator iterator = candidates.iterator();
                while (iterator.hasNext()) {
                    int v = iterator.nextInt();
                    if (!commits.contains(v)) continue;
                    commitsForSearch.add(v);
                }
            }
            IntOpenHashSet result2 = new IntOpenHashSet();
            IntIterator iterator = commitsForSearch.iterator();
            while (iterator.hasNext()) {
                int commit = iterator.nextInt();
                try {
                    String value = (String)this.myIndexStorage.messages.get((Object)commit);
                    if (value == null || !filter.matches(value)) continue;
                    result2.add(commit);
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    break;
                }
            }
            return result2;
        })) != null) {
            return resultByTrigrams;
        }
        return this.filter(this.myIndexStorage.messages, candidates, arg_0 -> ((VcsLogTextFilter)filter).matches(arg_0));
    }

    @NotNull
    private <T> IntSet filter(@NotNull PersistentMap<Integer, T> map2, @Nullable IntIterable candidates, @NotNull Condition<? super T> condition) {
        IntOpenHashSet result2 = new IntOpenHashSet();
        if (candidates == null) {
            return (IntSet)this.executeAndCatch(() -> this.lambda$filter$12(map2, condition, (IntSet)result2), result2);
        }
        IntIterator iterator = candidates.iterator();
        while (iterator.hasNext() && this.filterCommit(map2, iterator.nextInt(), condition, (IntSet)result2)) {
        }
        return result2;
    }

    private <T> boolean filterCommit(@NotNull PersistentMap<Integer, T> map2, int commit, @NotNull Condition<? super T> condition, @NotNull IntSet result2) {
        try {
            Object value = map2.get((Object)commit);
            if (value != null && condition.value(value)) {
                result2.add(commit);
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
        return true;
    }

    @NotNull
    private TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path2) {
        TIntObjectHashMap affectedCommits = new TIntObjectHashMap();
        VirtualFile root = VcsLogUtil.getActualRoot(this.myProject, path2);
        if (this.myRoots.contains(root) && root != null) {
            this.executeAndCatch(() -> {
                this.myIndexStorage.paths.iterateCommits(root, path2, (changes, commit) -> this.executeAndCatch(() -> {
                    List parents = (List)this.myIndexStorage.parents.get((Object)commit);
                    if (parents == null) {
                        throw new CorruptedDataException("No parents for commit " + commit);
                    }
                    TIntObjectHashMap changesMap = new TIntObjectHashMap();
                    if (parents.size() == 0 && !changes.isEmpty()) {
                        changesMap.put(commit, ContainerUtil.getFirstItem((List)changes));
                    } else {
                        if (parents.size() != changes.size()) {
                            throw new CorruptedDataException("Commit " + commit + " has " + parents.size() + " parents, but " + changes.size() + " changes.");
                        }
                        for (Pair parentAndChanges : ContainerUtil.zip((Iterable)parents, (Iterable)changes)) {
                            changesMap.put(((Integer)parentAndChanges.first).intValue(), parentAndChanges.second);
                        }
                    }
                    affectedCommits.put(commit, (Object)changesMap);
                    return null;
                }));
                return null;
            });
        }
        return affectedCommits;
    }

    @NotNull
    public FileHistoryData createFileHistoryData(@NotNull FilePath path2) {
        return this.createFileHistoryData(Collections.singletonList(path2));
    }

    @NotNull
    public FileHistoryData createFileHistoryData(@NotNull Collection<? extends FilePath> paths) {
        if (paths.size() == 1 && ((FilePath)ContainerUtil.getFirstItem(paths)).isDirectory()) {
            return new DirectoryHistoryData((FilePath)ContainerUtil.getFirstItem(paths));
        }
        return new FileHistoryDataImpl(paths);
    }

    @NotNull
    public VcsLogStorage getLogStorage() {
        return this.myLogStorage;
    }

    private static <T> void processKeys(@NotNull PersistentMap<Integer, T> map2, @NotNull Processor<Integer> processor) throws IOException {
        if (map2 instanceof PersistentHashMap) {
            ((PersistentHashMap)map2).processKeysWithExistingMapping(processor);
        } else {
            map2.processKeys(processor);
        }
    }

    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable) {
        return this.executeAndCatch(computable, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<? extends T, IOException, StorageException> computable, @Nullable T defaultValue) {
        try {
            return (T)computable.compute();
        }
        catch (StorageException | CorruptedDataException | IOException e) {
            this.myIndexStorage.markCorrupted();
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        return defaultValue;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        this.myIndexStorage.markCorrupted();
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    private /* synthetic */ IntSet lambda$filter$12(PersistentMap map2, Condition condition, IntSet result2) throws IOException, StorageException {
        IndexDataGetter.processKeys(map2, (Processor<Integer>)((Processor)commit -> this.filterCommit((PersistentMap)map2, (int)commit, (Condition)condition, result2)));
        return result2;
    }

    private static class CorruptedDataException
    extends RuntimeException {
        CorruptedDataException(@NotNull String message) {
            super(message);
        }
    }

    private final class DirectoryHistoryData
    extends FileHistoryDataImpl {
        private final Map<EdgeData<Integer>, EdgeData<FilePath>> renamesMap;

        private DirectoryHistoryData(FilePath startPath) {
            super(startPath);
            this.renamesMap = new HashMap<EdgeData<Integer>, EdgeData<FilePath>>();
            for (Map.Entry<EdgeData<CommitId>, EdgeData<FilePath>> entry : IndexDataGetter.this.myDirectoryRenamesProvider.getRenamesMap().entrySet()) {
                EdgeData<CommitId> commits = entry.getKey();
                EdgeData<FilePath> rename = entry.getValue();
                if (!VcsFileUtil.isAncestor(rename.getChild(), startPath, false)) continue;
                FilePath renamedPath = VcsUtil.getFilePath((String)(rename.getParent().getPath() + "/" + VcsFileUtil.relativePath(rename.getChild(), startPath)), (boolean)true);
                this.renamesMap.put(new EdgeData<Integer>(IndexDataGetter.this.myLogStorage.getCommitIndex(commits.getParent().getHash(), commits.getParent().getRoot()), IndexDataGetter.this.myLogStorage.getCommitIndex(commits.getChild().getHash(), commits.getChild().getRoot())), new EdgeData<FilePath>(renamedPath, startPath));
            }
        }

        @Override
        @NotNull
        public TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path2) {
            TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> affectedCommits = super.getAffectedCommits(path2);
            if (!path2.isDirectory()) {
                return affectedCommits;
            }
            this.hackAffectedCommits(path2, affectedCommits);
            return affectedCommits;
        }

        private void hackAffectedCommits(@NotNull FilePath path2, @NotNull TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> affectedCommits) {
            for (Map.Entry<EdgeData<Integer>, EdgeData<FilePath>> entry : this.renamesMap.entrySet()) {
                int childCommit = entry.getKey().getChild();
                if (!affectedCommits.containsKey(childCommit)) continue;
                EdgeData<FilePath> rename = entry.getValue();
                if (FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)rename.getChild(), (Object)path2)) {
                    ((TIntObjectHashMap)affectedCommits.get(childCommit)).transformValues(value -> VcsLogPathsIndex.ChangeKind.ADDED);
                    continue;
                }
                if (!FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)rename.getParent(), (Object)path2)) continue;
                ((TIntObjectHashMap)affectedCommits.get(childCommit)).transformValues(value -> VcsLogPathsIndex.ChangeKind.REMOVED);
            }
        }

        @Override
        @Nullable
        public EdgeData<FilePath> findRename(int parent, int child, @NotNull FilePath path2, boolean isChildPath) {
            if (path2.isDirectory()) {
                return this.findFolderRename(parent, child, path2, isChildPath);
            }
            return super.findRename(parent, child, path2, isChildPath);
        }

        @Nullable
        private EdgeData<FilePath> findFolderRename(int parent, int child, @NotNull FilePath path2, boolean isChildPath) {
            EdgeData<FilePath> rename = this.renamesMap.get(new EdgeData<Integer>(parent, child));
            if (rename == null) {
                return null;
            }
            return FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)(isChildPath ? rename.getChild() : rename.getParent()), (Object)path2) ? rename : null;
        }
    }

    private class FileHistoryDataImpl
    extends FileHistoryData {
        private FileHistoryDataImpl(FilePath startPath) {
            super(startPath);
        }

        private FileHistoryDataImpl(Collection<? extends FilePath> startPaths) {
            super(startPaths);
        }

        @Override
        @NotNull
        public TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path2) {
            return IndexDataGetter.this.getAffectedCommits(path2);
        }

        @Override
        @Nullable
        public EdgeData<FilePath> findRename(int parent, int child, @NotNull FilePath path2, boolean isChildPath) {
            VirtualFile root = Objects.requireNonNull(VcsLogUtil.getActualRoot(IndexDataGetter.this.myProject, path2));
            return (EdgeData)IndexDataGetter.this.executeAndCatch(() -> ((IndexDataGetter)IndexDataGetter.this).myIndexStorage.paths.findRename(parent, child, root, path2, isChildPath));
        }
    }
}

