/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.commit.message.BaseCommitMessageInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubjectBodySeparationInspection
extends BaseCommitMessageInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        return VcsBundle.message((String)"inspection.SubjectBodySeparationInspection.display.name", (Object[])new Object[0]);
    }

    @Override
    protected ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor descriptor = document.getLineCount() > 1 ? SubjectBodySeparationInspection.checkRightMargin(file, document, manager, isOnTheFly, 1, 0, "Missing blank line between subject and body", new AddBlankLineQuickFix(), new BaseCommitMessageInspection.ReformatCommitMessageQuickFix()) : null;
        return descriptor != null ? (ProblemDescriptor[])ContainerUtil.ar((Object[])new ProblemDescriptor[]{descriptor}) : null;
    }

    @Override
    public boolean canReformat(@NotNull Project project, @NotNull Document document) {
        return this.hasProblems(project, document);
    }

    @Override
    public void reformat(@NotNull Project project, @NotNull Document document) {
        new AddBlankLineQuickFix().doApplyFix(project, document, null);
    }

    protected static class AddBlankLineQuickFix
    extends BaseCommitMessageInspection.BaseCommitMessageQuickFix {
        protected AddBlankLineQuickFix() {
        }

        public @IntentionFamilyName @NotNull String getFamilyName() {
            return VcsBundle.getString((String)"settings.commit.message.body.add.blank.line.fix");
        }

        @Override
        public void doApplyFix(@NotNull Project project, @NotNull Document document, @Nullable ProblemDescriptor descriptor) {
            TextRange lineRange;
            int line;
            int n = line = descriptor != null && descriptor.getLineNumber() >= 0 ? descriptor.getLineNumber() : AddBlankLineQuickFix.getFirstLine(document);
            if (line >= 0 && !(lineRange = DocumentUtil.getLineTextRange((Document)document, (int)line)).isEmpty()) {
                document.insertString(lineRange.getStartOffset(), (CharSequence)"\n");
            }
        }

        private static int getFirstLine(@NotNull Document document) {
            return document.getLineCount() > 1 ? 1 : -1;
        }
    }
}

