/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.internal.statistic.IdeActivity;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.commit.AbstractCommitter;
import com.intellij.vcs.commit.AbstractCommitterKt;
import com.intellij.vcs.commit.SaveCommittingDocumentsVetoer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000 @2\u00020\u0001:\u0001@B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020+J\b\u00101\u001a\u00020/H$J\b\u00102\u001a\u00020/H$J\u001e\u00102\u001a\u00020/2\u0006\u00103\u001a\u0002042\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0004J\b\u00105\u001a\u00020/H\u0002J\b\u00106\u001a\u00020/H\u0002J\u0010\u00107\u001a\u00020/2\u0006\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020/H$J\b\u0010;\u001a\u00020/H$J\b\u0010<\u001a\u00020/H$J\u0016\u0010=\u001a\u00020/2\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u000209R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R:\u0010*\u001a.\u0012\f\u0012\n ,*\u0004\u0018\u00010+0+ ,*\u0015\u0012\f\u0012\n ,*\u0004\u0018\u00010+0+0\u0005\u00a2\u0006\u0002\b-0\r\u00a2\u0006\u0002\b-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/vcs/commit/AbstractCommitter;", "", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitMessage", "", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/vcs/changes/CommitContext;)V", "_exceptions", "", "Lcom/intellij/openapi/vcs/VcsException;", "_failedToCommitChanges", "_feedback", "", "_pathsToRefresh", "Lcom/intellij/openapi/vcs/FilePath;", "getChanges", "()Ljava/util/List;", "getCommitContext", "()Lcom/intellij/openapi/vcs/changes/CommitContext;", "getCommitMessage", "()Ljava/lang/String;", "configuration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "getConfiguration", "()Lcom/intellij/openapi/vcs/VcsConfiguration;", "exceptions", "getExceptions", "failedToCommitChanges", "getFailedToCommitChanges", "feedback", "", "getFeedback", "()Ljava/util/Set;", "pathsToRefresh", "getPathsToRefresh", "getProject", "()Lcom/intellij/openapi/project/Project;", "resultHandlers", "Lcom/intellij/openapi/vcs/changes/CommitResultHandler;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addResultHandler", "", "resultHandler", "afterCommit", "commit", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "delegateCommitToVcsThread", "doRunCommit", "finishCommit", "canceled", "", "onFailure", "onFinish", "onSuccess", "runCommit", "taskName", "sync", "Companion", "intellij.platform.vcs.impl"})
public abstract class AbstractCommitter {
    private final List<CommitResultHandler> resultHandlers;
    private final Set<String> _feedback;
    private final List<Change> _failedToCommitChanges;
    private final List<VcsException> _exceptions;
    private final List<FilePath> _pathsToRefresh;
    @NotNull
    private final VcsConfiguration configuration;
    @NotNull
    private final Project project;
    @NotNull
    private final List<Change> changes;
    @NotNull
    private final String commitMessage;
    @NotNull
    private final CommitContext commitContext;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Set<String> getFeedback() {
        return CollectionsKt.toSet((Iterable)this._feedback);
    }

    @NotNull
    public final List<Change> getFailedToCommitChanges() {
        return CollectionsKt.toList((Iterable)this._failedToCommitChanges);
    }

    @NotNull
    public final List<VcsException> getExceptions() {
        return CollectionsKt.toList((Iterable)this._exceptions);
    }

    @NotNull
    public final List<FilePath> getPathsToRefresh() {
        return CollectionsKt.toList((Iterable)this._pathsToRefresh);
    }

    @NotNull
    public final VcsConfiguration getConfiguration() {
        return this.configuration;
    }

    public final void addResultHandler(@NotNull CommitResultHandler resultHandler) {
        Collection collection = this.resultHandlers;
        boolean bl = false;
        collection.add(resultHandler);
    }

    public final void runCommit(@NotNull String taskName, boolean sync) {
        Task.Backgroundable task2 = new Task.Backgroundable(this, sync, taskName, this.project, taskName, true, this.configuration.getCommitOption()){
            final /* synthetic */ AbstractCommitter this$0;
            final /* synthetic */ boolean $sync;
            final /* synthetic */ String $taskName;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)this.myProject);
                IdeActivity activity = IdeActivity.Companion.started(this.myProject, "vcs", "commit");
                vcsManager2.startBackgroundVcsOperation();
                try {
                    AbstractCommitter.access$delegateCommitToVcsThread(this.this$0);
                }
                finally {
                    vcsManager2.stopBackgroundVcsOperation();
                    activity.finished();
                }
            }

            public boolean shouldStartInBackground() {
                return !this.$sync && super.shouldStartInBackground();
            }

            public boolean isConditionalModal() {
                return this.$sync;
            }
            {
                this.this$0 = this$0;
                this.$sync = $captured_local_variable$1;
                this.$taskName = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
        task2.queue();
    }

    protected abstract void commit();

    protected abstract void afterCommit();

    protected abstract void onSuccess();

    protected abstract void onFailure();

    protected abstract void onFinish();

    protected final void commit(@NotNull AbstractVcs vcs, @NotNull List<? extends Change> changes) {
        CheckinEnvironment environment = vcs.getCheckinEnvironment();
        if (environment != null) {
            this._pathsToRefresh.addAll(ChangesUtil.getPaths((Collection)changes));
            List exceptions = environment.commit(changes, this.commitMessage, this.commitContext, this._feedback);
            Collection collection = exceptions;
            boolean bl = false;
            boolean bl2 = false;
            if (!(collection == null || collection.isEmpty())) {
                this._exceptions.addAll(exceptions);
                this._failedToCommitChanges.addAll((Collection<Change>)changes);
            }
        }
    }

    private final void delegateCommitToVcsThread() {
        DelegatingProgressIndicator indicator = new DelegatingProgressIndicator();
        TransactionGuard.getInstance().assertWriteSafeContext(indicator.getModalityState());
        Semaphore endSemaphore = new Semaphore();
        endSemaphore.down();
        ChangeListManagerImpl.getInstanceImpl(this.project).executeOnUpdaterThread(new Runnable(this, indicator, endSemaphore){
            final /* synthetic */ AbstractCommitter this$0;
            final /* synthetic */ DelegatingProgressIndicator $indicator;
            final /* synthetic */ Semaphore $endSemaphore;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                this.$indicator.setText(VcsBundle.message((String)"message.text.commit.progress", (Object[])new Object[0]));
                try {
                    ProgressManager.getInstance().runProcess(new Runnable(this){
                        final /* synthetic */ delegateCommitToVcsThread.1 this$0;

                        public final void run() {
                            this.this$0.$indicator.checkCanceled();
                            AbstractCommitter.access$doRunCommit(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, (ProgressIndicator)this.$indicator);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    AbstractCommitterKt.access$getLOG$p().error(e);
                }
                finally {
                    this.$endSemaphore.up();
                }
            }
            {
                this.this$0 = abstractCommitter;
                this.$indicator = delegatingProgressIndicator;
                this.$endSemaphore = semaphore;
            }
        });
        indicator.setText(VcsBundle.message((String)"message.text.background.tasks", (Object[])new Object[0]));
        ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)endSemaphore, (ProgressIndicator)((ProgressIndicator)indicator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRunCommit() {
        boolean canceled = false;
        try {
            SaveCommittingDocumentsVetoer.Companion.run(this.project, (Collection<? extends Change>)this.changes, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ AbstractCommitter this$0;

                public final void invoke() {
                    this.this$0.commit();
                }
                {
                    this.this$0 = abstractCommitter;
                    super(0);
                }
            }));
            this.afterCommit();
        }
        catch (ProcessCanceledException e) {
            canceled = true;
            throw (Throwable)e;
        }
        catch (Throwable e) {
            AbstractCommitterKt.access$getLOG$p().error(e);
            this._exceptions.add(new VcsException(e));
        }
        finally {
            this.finishCommit(canceled);
            this.onFinish();
        }
    }

    private final void finishCommit(boolean canceled) {
        List<VcsException> errors = Companion.collectErrors(this._exceptions);
        boolean noErrors = errors.isEmpty();
        boolean noWarnings = this._exceptions.isEmpty();
        if (canceled) {
            Iterable $this$forEach$iv = this.resultHandlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CommitResultHandler it = (CommitResultHandler)element$iv;
                boolean bl = false;
                it.onCancel();
            }
        } else if (noErrors) {
            Iterable $this$forEach$iv = this.resultHandlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CommitResultHandler it = (CommitResultHandler)element$iv;
                boolean bl = false;
                it.onSuccess(this.commitMessage);
            }
            this.onSuccess();
            if (noWarnings) {
                Companion.progress$intellij_platform_vcs_impl(VcsBundle.message((String)"commit.dialog.completed.successfully", (Object[])new Object[0]));
            }
        } else {
            Iterable $this$forEach$iv = this.resultHandlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CommitResultHandler it = (CommitResultHandler)element$iv;
                boolean bl = false;
                it.onFailure(errors);
            }
            this.onFailure();
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<Change> getChanges() {
        return this.changes;
    }

    @NotNull
    public final String getCommitMessage() {
        return this.commitMessage;
    }

    @NotNull
    public final CommitContext getCommitContext() {
        return this.commitContext;
    }

    public AbstractCommitter(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull String commitMessage2, @NotNull CommitContext commitContext) {
        this.project = project;
        this.changes = changes;
        this.commitMessage = commitMessage2;
        this.commitContext = commitContext;
        this.resultHandlers = ContainerUtil.createLockFreeCopyOnWriteList();
        boolean bl = false;
        this._feedback = new LinkedHashSet();
        bl = false;
        this._failedToCommitChanges = new ArrayList();
        bl = false;
        this._exceptions = new ArrayList();
        bl = false;
        this._pathsToRefresh = new ArrayList();
        this.configuration = VcsConfiguration.getInstance((Project)this.project);
    }

    public static final /* synthetic */ void access$delegateCommitToVcsThread(AbstractCommitter $this) {
        $this.delegateCommitToVcsThread();
    }

    public static final /* synthetic */ void access$doRunCommit(AbstractCommitter $this) {
        $this.doRunCommit();
    }

    @JvmStatic
    @NotNull
    public static final List<VcsException> collectErrors(@NotNull List<? extends VcsException> exceptions) {
        return Companion.collectErrors(exceptions);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/commit/AbstractCommitter$Companion;", "", "()V", "collectErrors", "", "Lcom/intellij/openapi/vcs/VcsException;", "exceptions", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "message", "", "progress$intellij_platform_vcs_impl", "intellij.platform.vcs.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<VcsException> collectErrors(@NotNull List<? extends VcsException> exceptions) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = exceptions;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                VcsException it = (VcsException)((Object)element$iv$iv);
                boolean bl = false;
                if (it.isWarning()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final ProgressIndicator progress$intellij_platform_vcs_impl(@NotNull String message) {
            ProgressIndicator progressIndicator;
            ProgressIndicator progressIndicator2 = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator2 != null) {
                ProgressIndicator progressIndicator3 = progressIndicator2;
                boolean bl = false;
                boolean bl2 = false;
                ProgressIndicator $this$apply = progressIndicator3;
                boolean bl3 = false;
                $this$apply.setText(message);
                $this$apply.setText2("");
                progressIndicator = progressIndicator3;
            } else {
                progressIndicator = null;
            }
            return progressIndicator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

