/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class ViewUpdateInfoNotification
extends NotificationAction {
    @NotNull
    private final Project myProject;
    @NotNull
    private final UpdateInfoTree myTree;

    public ViewUpdateInfoNotification(@NotNull Project project, @NotNull UpdateInfoTree updateInfoTree, @NotNull String actionName, final @NotNull Notification notification) {
        super(actionName);
        this.myProject = project;
        this.myTree = updateInfoTree;
        Disposer.register((Disposable)updateInfoTree, (Disposable)new Disposable(){

            public void dispose() {
                notification.expire();
            }
        });
    }

    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
        ViewUpdateInfoNotification.focusUpdateInfoTree(this.myProject, this.myTree);
        notification.expire();
    }

    public static void focusUpdateInfoTree(@NotNull Project project, @NotNull UpdateInfoTree updateInfoTree) {
        ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control").activate(() -> {
            ContentManager contentManager = ProjectLevelVcsManagerEx.getInstanceEx(project).getContentManager();
            if (contentManager != null) {
                ContentUtilEx.selectContent((ContentManager)contentManager, (JComponent)((Object)updateInfoTree), (boolean)true);
            }
        }, true, true);
    }
}

